require "base/internal/ui/reflexcore"
require "base/internal/ui/thcHUD/thc_core"

THC_Awards =
{
};
registerWidget("THC_Awards");

local lastScore = {};
local lastStack = {};
local railAmmoCounter = {};

local function getStack(player) return math.max(0,(player.health+math.min(math.floor(player.health*(player.armorProtection+1)),player.armor))) end
local function scaleTransition(x) return (x*(2-x))^2 end

local function defineAward(params)
	local _award = {}
	local awardCounter = {}
	local awardTimer = {}
	local awardTotal = {}
	local awardLast = {}
	local awardLastWidth = {}
	_award.counter = alerCounter
	_award.timer = awardTimer
	_award.total = awardTotal
	_award.last = awardLast
	_award.lastMessage = nil
	_award.lastWidth = awardLastWidth
	_award.lastOffset = {}
	local _icon = params.ICON
	local _text = params.TEXT
	local _subtext = params.SUBTEXT
	local _sound = params.SOUND
	local _timeout = params.TIMEOUT
	local _fade_in = params.FADE_IN or 0
	local _display_time = params.DISPLAY_TIME or 0
	local _fade_out = params.FADE_OUT or 0
	local _duration = _fade_in + _display_time + _fade_out
	_award.reset =
		function(playerIndex)
			awardCounter[playerIndex] = nil
			if _duration == 0 then
				awardTimer[playerIndex] = -1
				_award.last[playerIndex] = nil
				_award.lastWidth[playerIndex] = 0
				_award.lastOffset[playerIndex] = 0
			end
		if awardTimer[playerIndex] == -1 then
				awardTimer[playerIndex] = nil
				_award.last[playerIndex] = nil
				_award.lastWidth[playerIndex] = 0
				_award.lastOffset[playerIndex] = 0
			end
		end
	_award.getCounter = function(playerIndex) return awardCounter[playerIndex] or 0 end
	_award.tick =
		function()
			for playerIndex,timer in pairs(awardTimer) do
				if timer and timer >= 0 then awardTimer[playerIndex] = timer + deltaTime end
				if _timeout and awardTimer[playerIndex] >= _timeout then
					awardCounter[playerIndex] = nil
				end
				if (not _timeout or awardTimer[playerIndex] >= _timeout) and (_duration > 0 and awardTimer[playerIndex] >= _duration) then
					awardTimer[playerIndex] = -1
				end
			end
		end
	_award.transition =
		function(playerIndex)
			local alpha
			local direction
			local timer = awardTimer[playerIndex]
			if _duration == 0 and timer and timer >= 0 then return 255 end
			if not timer or timer >= _duration or timer < 0 then return end
			if timer < _fade_in then
				alpha = 255 * timer / _fade_in
				direction = 1
			else
				local timeleft = _duration - timer
				if timeleft < _fade_out then
					alpha = 255 * timeleft / _fade_out
					direction = -1
				else
					alpha = 255
					direction = 0
				end
			end
			return roundHalfUp(alpha), direction
		end
	_award.set =
		function(playerIndex)
			awardCounter[playerIndex] = (awardCounter[playerIndex] or 0) + 1
			awardTimer[playerIndex] = 0
			if awardCounter[playerIndex] >= params.THRESHOLD then
				awardTotal[playerIndex] = (awardTotal[playerIndex] or 0) + 1
				local text = _text
				local subtext = _subtext(awardCounter[playerIndex])
				local counter = awardCounter[playerIndex]
				local theme = params.THEME(counter)
				nvgSave()
				nvgFontFace(params.FONT_FACE)
				nvgFontSize(params.FONT_SIZE_TEXT)
				local textWidth = text and nvgTextWidth(text) or 0
				nvgFontSize(params.FONT_SIZE_SUBTEXT)
				local subtextWidth = subtext and nvgTextWidth(subtext) or 0
				nvgRestore()
				local halfWidth = math.ceil(((text and subtext and params.DIVIDER_WIDTH or 0) + math.max(textWidth,subtextWidth))/2)
				_award.lastWidth[playerIndex] = halfWidth+20
				_award.lastOffset[playerIndex] = 0
				_award.last[playerIndex] =
					function(xOffset,yOffset,scale)
						local alpha, direction = _award.transition(playerIndex)
						if alpha and alpha >=0 then
							if theme.FULLSCREEN_BACKGROUND then
								nvgBeginPath()
								nvgFillColor(theme.FULLSCREEN_BACKGROUND(alpha))
								nvgRect(-viewport.width/2,-viewport.height/2,viewport.width,viewport.height)
								nvgFill()
							end
							nvgSave()
							nvgTranslate(xOffset,yOffset+params.ICON_Y)
							if scale and scale ~= 0 and scale ~= 1 then nvgScale(scale,scale) end
							if alpha > 0 and direction == 1 then nvgScale(scaleTransition(alpha/255),scaleTransition(alpha/255)) elseif awardTimer[playerIndex] == -1 then _award.last[playerIndex] = nil _award.lastWidth[playerIndex] = 0 _award.lastOffset[playerIndex] = 0 end
							if alpha > 0 then thc_drawAward((direction == -1 and alpha or 255), halfWidth, _icon, text, subtext, params, theme, counter) end
							nvgRestore()
							return true
						else _award.last[playerIndex] = nil _award.lastWidth[playerIndex] = 0 _award.lastOffset[playerIndex] = 0 return false end
					end
				if playerIndex == playerIndexCameraAttachedTo and _sound then playSound(_sound) end
			end
		end
	_award.message =
		function(index,icon,text,subtext,counter,params_override)
			if not params_override then params_override = params end
			if not text then text = params_override.TEXT end
			if not subtext and params_override.SUBTEXT then subtext = params_override.SUBTEXT(counter or -1) end
			awardTimer[index] = 0
			if not counter then if awardCounter[index] then counter = awardCounter[index]-params_override.THRESHOLD+1 end end
			local theme = params_override.THEME(counter)
			nvgSave()
			nvgFontFace(params.FONT_FACE)
			nvgFontSize(params.FONT_SIZE_TEXT)
			local textWidth = text and nvgTextWidth(text) or 0
			nvgFontSize(params.FONT_SIZE_SUBTEXT)
			local subtextWidth = subtext and nvgTextWidth(subtext) or 0
			nvgRestore()
			local halfWidth = math.ceil(((text and subtext and params.DIVIDER_WIDTH or 0) + math.max(textWidth,subtextWidth))/2)
			_award.lastWidth[index] = halfWidth+20
			_award.lastOffset[index] = 0
			_award.last[index] =
				function(xOffset,yOffset,scale,start)
					if start == index then return true elseif not start then start = index end
					local alpha, direction = _award.transition(index)
					if alpha and alpha >=0 then
						if theme.FULLSCREEN_BACKGROUND then
							nvgBeginPath()
							nvgFillColor(theme.FULLSCREEN_BACKGROUND(alpha))
							nvgRect(-viewport.width/2,-viewport.height/2,viewport.width,viewport.height)
							nvgFill()
						end
						nvgSave()
						nvgTranslate(xOffset,yOffset+params.ICON_Y)
						if scale and scale ~= 0 and scale ~= 1 then nvgScale(scale,scale) end
						if alpha > 0 and direction == 1 then nvgScale(scaleTransition(alpha/255),scaleTransition(alpha/255)) elseif awardTimer[index] == -1 then _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 end
						if alpha > 0 then thc_drawAward((direction == -1 and alpha or 255), halfWidth, icon or _icon, text or _text, subtext, params_override, theme, counter) end
						nvgRestore()
						return true
					else _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 return false end
				end
			_award.lastMessage = function(xOffset,yOffset,scale) return checkDrawLastMessage(index,xOffset,yOffset,scale) end
			if index == playerIndexCameraAttachedTo and _sound then playSound(_sound) end
		end
	local feedIndex = 1
	local checkDrawLastMessage = function(index,xOffset,yOffset,scale,start) return _award.last[index] and _award.last[index](xOffset,yOffset,scale,start) end
	_award.feedMessage =
		function(icon,text,subtext,counter,params_override)
			if not params_override then params_override = params end
			feedIndex = (feedIndex%(params.MAX_FEED or 8))+1
			local index = feedIndex
			awardTimer[index] = 0
			if not counter then if awardCounter[index] then counter = awardCounter[index]-params_override.THRESHOLD+1 end end
			local theme = params_override.THEME(counter)
			nvgSave()
			nvgFontFace(params.FONT_FACE)
			nvgFontSize(params.FONT_SIZE_TEXT)
			local textWidth = text and nvgTextWidth(text) or 0
			nvgFontSize(params.FONT_SIZE_SUBTEXT)
			local subtextWidth = subtext and nvgTextWidth(subtext) or 0
			nvgRestore()
			local halfWidth = math.ceil(((text and subtext and params.DIVIDER_WIDTH or 0) + math.max(textWidth,subtextWidth))/2)
			_award.lastWidth[index] = halfWidth+20
			_award.lastOffset[index] = 0
			_award.last[index] =
				function(xOffset,yOffset,scale,start)
					if start == index then return true elseif not start then start = index end
					local alpha, direction = _award.transition(index)
					if alpha and alpha >=0 then
						nvgSave()
						nvgTranslate(xOffset,yOffset+params.ICON_Y)
						if scale and scale ~= 0 and scale ~= 1 then nvgScale(scale,scale) end
						if alpha > 0 and direction == 1 then nvgScale(scaleTransition(alpha/255),scaleTransition(alpha/255)) elseif awardTimer[index] == -1 then _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 end
						if alpha > 0 then thc_drawAward((direction == -1 and alpha or 255), halfWidth, icon or _icon, text or _text, subtext, params_override, theme, counter) end
						nvgRestore()
						nvgTranslate(0,(params_override.FULL_SPACED_HEIGHT or 0)*(scale or 1)*(scaleTransition(math.min(alpha,128)/128)))
						return checkDrawLastMessage(index == 1 and 16 or index-1,xOffset,yOffset,scale,start)
					else _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 return false end
				end
			_award.lastMessage = function(xOffset,yOffset,scale) return checkDrawLastMessage(index,xOffset,yOffset,scale) end
			if index == playerIndexCameraAttachedTo and _sound then playSound(_sound) end
		end
	_award.feedMessage =
		function(icon,text,subtext,counter,params_override)
			if not params_override then params_override = params end
			feedIndex = (feedIndex%16)+1
			local index = feedIndex
			awardTimer[index] = 0
			if not counter then if awardCounter[index] then counter = awardCounter[index]-params_override.THRESHOLD+1 end end
			local theme = params_override.THEME(counter)
			nvgSave()
			nvgFontFace(params.FONT_FACE)
			nvgFontSize(params.FONT_SIZE_TEXT)
			local textWidth = text and nvgTextWidth(text) or 0
			nvgFontSize(params.FONT_SIZE_SUBTEXT)
			local subtextWidth = subtext and nvgTextWidth(subtext) or 0
			nvgRestore()
			local halfWidth = math.ceil(((text and subtext and params.DIVIDER_WIDTH or 0) + math.max(textWidth,subtextWidth))/2)
			_award.lastWidth[index] = halfWidth+20
			_award.lastOffset[index] = 0
			_award.last[index] =
				function(xOffset,yOffset,scale,start)
					if start == index then return true elseif not start then start = index end
					local alpha, direction = _award.transition(index)
					if alpha and alpha >=0 then
						nvgSave()
						nvgTranslate(xOffset,yOffset+params.ICON_Y)
						if scale and scale ~= 0 and scale ~= 1 then nvgScale(scale,scale) end
						if alpha > 0 and direction == 1 then nvgScale(scaleTransition(alpha/255),scaleTransition(alpha/255)) elseif awardTimer[index] == -1 then _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 end
						if alpha > 0 then thc_drawAward((direction == -1 and alpha or 255), halfWidth, icon or _icon, text or _text, subtext, params_override, theme, counter) end
						nvgRestore()
						nvgTranslate(0,(params_override.FULL_SPACED_HEIGHT or 0)*(scale or 1)*(scaleTransition(math.min(alpha,128)/128)))
						return checkDrawLastMessage(index == 1 and 16 or index-1,xOffset,yOffset,scale,start)
					else _award.last[index] = nil _award.lastWidth[index] = 0 _award.lastOffset[index] = 0 return false end
				end
			_award.lastMessage = function(xOffset,yOffset,scale) return checkDrawLastMessage(index,xOffset,yOffset,scale) end
			if index == playerIndexCameraAttachedTo and _sound then playSound(_sound) end
		end
	_award.fullReset =
		function()
			for i in pairs(awardTotal) do awardTotal[i] = nil end
			for i in pairs(awardTimer) do awardTimer[i] = nil end
			for i in pairs(awardCounter) do awardCounter[i] = nil end
			for i in pairs(awardLast) do awardLast[i] = nil end
		end
	return _award
end

local impressiveAward = defineAward(THC_AWARD.IMPRESSIVE)
local excellentAward = defineAward(THC_AWARD.EXCELLENT)
local deadAward = defineAward(THC_AWARD.DEAD)
local killAward = defineAward(THC_AWARD.KILL)

local lastPlayerIndexCameraAttachedTo = nil

function THC_Awards:draw()
	local localPlayer = getLocalPlayer()
	if not localPlayer
		or not world
		or world.gameState == GAME_STATE_GAMEOVER
		or not localPlayer.connected then
			if next(railAmmoCounter) then railAmmoCounter = {} end
			if next(lastStack) then lastStack = {} end
			if next(lastScore) then lastScore = {} end
			impressiveAward.fullReset()
			excellentAward.fullReset()
			deadAward.fullReset()
			killAward.fullReset()
			return
	end

	local isInGame = (localPlayer.state == PLAYER_STATE_INGAME)

	local yOffsetGeneral = consoleGetVariable("ui_thc_award_y")
	local xOffsetFragMessage = isInGame and consoleGetVariable("ui_thc_killfeed_ingame_x") or consoleGetVariable("ui_thc_killfeed_spec_x")
	local yOffsetFragMessage = isInGame and consoleGetVariable("ui_thc_killfeed_ingame_y") or consoleGetVariable("ui_thc_killfeed_spec_y")
	local scaleFragMessage = isInGame and consoleGetVariable("ui_thc_killfeed_ingame_scale") or consoleGetVariable("ui_thc_killfeed_spec_scale")



	local drawImpressive
	local drawExcellent
	local drawKillfeed
	local drawDeathscreen

	if isInGame then
		drawImpressive = false
		if next(railAmmoCounter) then railAmmoCounter = {} end
		if next(lastStack) then lastStack = {} end
		impressiveAward.fullReset()
		if consoleGetVariable("ui_thc_award_excellent") >= 2 then
			drawExcellent = true
		else
			drawExcellent = false
			if next(lastScore) then lastScore = {} end
			excellentAward.fullReset()
		end
		if consoleGetVariable("ui_thc_killfeed_show") >= 2 then
			drawKillfeed = true
		else
			drawKillfeed = false
			killAward.fullReset()
		end
		if consoleGetVariable("ui_thc_deathscreen_show") >= 2 then
			drawDeathscreen = true
		else
			drawDeathScreen = false
			deadAward.fullReset()
		end
	else
		if consoleGetVariable("ui_thc_award_impressive") >= 1 then
			drawImpressive = true
		else
			drawImpressive = false
			if next(railAmmoCounter) then railAmmoCounter = {} end
			if next(lastStack) then lastStack = {} end
			impressiveAward.fullReset()
		end
		if consoleGetVariable("ui_thc_award_excellent") >= 1 then
			drawExcellent = true
		else
			drawExcellent = false
			if next(lastScore) then lastScore = {} end
			excellentAward.fullReset()
		end
		if consoleGetVariable("ui_thc_killfeed_show") >= 1 then
			drawKillfeed = true
		else
			drawKillfeed = false
			killAward.fullReset()
		end
		if consoleGetVariable("ui_thc_deathscreen_show") >= 1 then
			drawDeathscreen = true
		else
			drawDeathScreen = false
			deadAward.fullReset()
		end
	end

	for i=1,#log do
		if log[i].age > deltaTime then break end
		if log[i].type == LOG_TYPE_DEATHMESSAGE then
			if not log[i].deathSuicide then
				if drawKillfeed then killAward.feedMessage(thc_damageSvg[log[i].deathDamageType],log[i].deathKiller,log[i].deathKilled,log[i].deathDamageType) end
				for p,player in pairs(players) do
					if player.connected then
						if player.state == PLAYER_STATE_INGAME and player.health <= 0 then
							if log[i].deathKilled == player.name then deadAward.message(p,nil,nil,string.format("%s was killed by %s",log[i].deathKilled,log[i].deathKiller)) end
						end
					end
				end
			else
				if drawKillfeed then killAward.feedMessage(thc_damageSvg[log[i].deathDamageType],nil,log[i].deathKilled,log[i].deathDamageType,THC_AWARD.SUICIDE) end
				for p,player in pairs(players) do
					if player.connected then
						if player.state == PLAYER_STATE_INGAME and player.health <= 0 then
							if log[i].deathKilled == player.name then deadAward.message(p,nil,nil,string.format(thc_suicideString[log[i].deathDamageType],log[i].deathKilled)) end
						end
					end
				end
			end
		end
	end

	for p,player in pairs(players) do
		if player.connected and player.state == PLAYER_STATE_INGAME then
			if drawImpressive and world.gameState == GAME_STATE_ACTIVE then
				if not player.weaponIndexSelected == THC_WEAPON_RAIL then impressiveAward.reset(p)
				elseif railAmmoCounter[p] and railAmmoCounter[p] == player.weapons[THC_WEAPON_RAIL].ammo + 1 then
					local impressed = false;
					for o,opponent in pairs(players) do
						if o ~= p and opponent.connected and opponent.state == PLAYER_STATE_INGAME and lastStack[o] then
							if getStack(opponent) + 80 == lastStack[o] or lastScore[p] < player.score then if player.health > 0 then impressiveAward.set(p) end impressed = true; break end
						end
					end
					if not impressed then impressiveAward.reset(p) end
				end
			end
			if player.health <= 0 then
				if drawImpressive then impressiveAward.reset(p) end
				if drawExcellent then excellentAward.reset(p) end
			else
				if drawDeathscreen then deadAward.reset(p) end
				if drawExcellent and world.gameState == GAME_STATE_ACTIVE and lastScore[p] and lastScore[p] < player.score then
					excellentAward.set(p)
				end
			end
		end
	end

	if thc_shouldDrawGameHud() then
		if not (deadAward.last[playerIndexCameraAttachedTo] and deadAward.last[playerIndexCameraAttachedTo](0,0)) then
			nvgSave()
			if killAward.lastMessage then killAward.lastMessage(xOffsetFragMessage,yOffsetFragMessage,scaleFragMessage) end
			nvgRestore()
			if world.gameState == GAME_STATE_ACTIVE then
				local excellentAlpha, excellentDirection = excellentAward.transition(playerIndexCameraAttachedTo)
				local impressiveAlpha, impressiveDirection = impressiveAward.transition(playerIndexCameraAttachedTo)
				nvgSave()
				if excellentAward.last[playerIndexCameraAttachedTo] then
					local xOffset = (impressiveAlpha and impressiveAward.last[playerIndexCameraAttachedTo] and -excellentAward.lastWidth[playerIndexCameraAttachedTo] or 0)
					nvgTranslate(xOffset,0)
					excellentAward.last[playerIndexCameraAttachedTo](0,yOffsetGeneral)
				end
				nvgRestore()
				nvgSave()
				if impressiveAward.last[playerIndexCameraAttachedTo] then
					local xOffset = (excellentAlpha and excellentAward.last[playerIndexCameraAttachedTo] and impressiveAward.lastWidth[playerIndexCameraAttachedTo] or 0)
					nvgTranslate(xOffset,0)
					impressiveAward.last[playerIndexCameraAttachedTo](0,yOffsetGeneral)
				end
				nvgRestore()
			end
		end
	end

	for p,player in pairs(players) do
		if player.connected and player.state == PLAYER_STATE_INGAME then
			if drawImpressive then
				railAmmoCounter[p] = player.weapons[THC_WEAPON_RAIL].ammo;
				lastStack[p] = getStack(player);
			end
			if drawExcellent then lastScore[p] = player.score end
		end
	end

	if drawImpressive then impressiveAward.tick() end
	if drawExcellent then excellentAward.tick() end
	if drawKillfeed then killAward.tick() end
	if drawDeathscreen then deadAward.tick() end
	
end
