require "base/internal/ui/reflexcore"
require "base/internal/ui/thcHUD/thc_core"

THC_ClockMessages =
{
}
registerWidget("THC_ClockMessages")

local function getCountdownString(n)
	if type(n) == "number" then
		playSound("internal/ui/match/match_countdown_tick")
		return tostring(n)
	end
end

local function drawCountdownString(msg,k)
	nvgFontFace(THC_COUNTDOWN_FONT_FACE)
	nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
	nvgFontBlur(0)
	nvgFillColor(THC_COUNTDOWN_FONT_COLOR((1-k)*255))
	nvgFontSize(lerp(THC_COUNTDOWN_SIZE_START,THC_COUNTDOWN_SIZE_END,k))
	nvgText(0,0,msg)
end

local drawCountdown = thc_getCounterFunction(1000,0,1/1000,getCountdownString,drawCountdownString,false)
local error_drawText = false
local error_drawWinner = false
local error_drawPlus2 = false

function THC_ClockMessages:draw()
	if not thc_shouldTickGameHud() or not world.timerActive then return end
	
	if world.gameState == GAME_STATE_WARMUP or world.gameState == GAME_STATE_ROUNDPREPARE then
		local timeRemaining = world.gameTimeLimit - world.gameTime;
		if timeRemaining > 0 then drawCountdown(timeRemaining) else drawCountdownString(THC_COUNTDOWN_STRING_FIGHT,0) end
	elseif world.gameState == GAME_STATE_ACTIVE then
		local timer = world.gameTime
		if timer >= 0 and timer < THC_COUNTDOWN_TEXT_TOTAL_TIME then
			local k
			if timer < THC_COUNTDOWN_TEXT_DISPLAY_TIME then
				k = 0
			else
				k = (timer - THC_COUNTDOWN_TEXT_DISPLAY_TIME)/THC_COUNTDOWN_TEXT_FADE_TIME
			end
			if world.overTimeCount == 0 then
				drawCountdownString(THC_COUNTDOWN_STRING_FIGHT,k)
			else
				drawCountdownString(THC_COUNTDOWN_STRING_OVERTIME(world.overTimeCount),k)
			end
		end
	end

	-- Copied from GameMessages.lua until I get round to writing my own version
		-- ROUND DRAW
		if world.gameState == GAME_STATE_ROUNDCOOLDOWN_DRAW then
			if drawText then drawText("Round Draw") elseif not error_drawText then error_drawText = true consolePrint("THC_ClockMessages requires GameMessages to be present (missing function: drawText)") end
		end

		-- announce winner
		if world.gameState == GAME_STATE_ROUNDCOOLDOWN_SOMEONEWON then
			if drawWinner then drawWinner() elseif not error_drawWinner then error_drawWinner = true consolePrint("THC_ClockMessages requires GameMessages to be present (missing function: drawWinner)") end
		end

		-- announce +2 to win
		if world.gameState == GAME_STATE_ROUNDPREPARE then
			if drawPlus2 then drawPlus2() elseif not error_drawPlus2 then error_drawPlus2 = true consolePrint("THC_ClockMessages requires GameMessages to be present (missing function: drawPlus2)") end
		end

end

THC_Clock =
{
}
registerWidget("THC_Clock")

local function drawCountUpClock()
	if not world.gameTimeLimit or not world.gameTime then return end
	local milliseconds = world.gameTime
	local seconds = math.floor(milliseconds / 1000)
	local minutes = math.floor(seconds / 60)
	seconds = seconds - minutes * 60
	if world.overTimeCount == 0 then thc_drawClock(milliseconds,seconds,minutes,THC_CLOCK.MAIN_TIME(world.gameTimeLimit)) end
end

local function drawClock(params,mode)
	if not world.gameTimeLimit or not world.gameTime then return end
	nvgSave()
	nvgTranslate(0,math.ceil(params.OUTER_BORDER_RADIUS))
	local milliseconds = world.gameTime
	local millisecondsRemaining = world.gameTimeLimit - milliseconds
	local seconds
	local minutes
	local digitOffset
	local minutesColor
	local secondsColor
	local isTimeRunningOut = (millisecondsRemaining <= 1000*consoleGetVariable("ui_thc_clock_low_seconds"))
	if not mode or mode >= 2 then
		digitOffset = math.ceil(params.OUTER_BORDER_RADIUS)
		seconds = math.ceil(millisecondsRemaining / 1000)
		minutes = math.floor(seconds/60)
		secondsColor = params.FONT_COLOR_SECONDS
		seconds =  string.format("%02i",seconds - minutes * 60)
		minutesColor = params.FONT_COLOR_MINUTES
		minutes = string.format("%02i",minutes)
		params.DRAW_DETAIL(milliseconds)
	elseif mode >= 0 then
		digitOffset = math.ceil(params.FONT_SIZE_DIGITS/6)
		seconds = math.ceil(millisecondsRemaining/1000)
		minutes = math.floor(seconds/60)
		if mode == 0 and not isTimeRunningOut then
			secondsColor = params.FONT_COLOR_SECONDS_XX
			seconds = "××"
		else
			secondsColor = params.FONT_COLOR_SECONDS
			seconds = string.format("%02i",seconds - minutes * 60)
		end
		minutesColor = params.FONT_COLOR_MINUTES
		minutes = string.format("%02i",minutes)
		nvgSave()
		nvgTranslate(0,params.COLON_Y)
		nvgBeginPath()
		thc_drawHexagonPath(params.COLON_BORDER_RADIUS)
		nvgFillColor(params.COLON_BORDER_COLOR)
		nvgFill()
		nvgBeginPath()
		nvgCircle(0,0,params.COLON_RADIUS)
		nvgFillColor(minutesColor)
		nvgFill()
		nvgRestore()
		nvgSave()
		nvgTranslate(0,-params.COLON_Y)
		nvgBeginPath()
		thc_drawHexagonPath(params.COLON_BORDER_RADIUS)
		nvgFillColor(params.COLON_BORDER_COLOR)
		nvgFill()
		nvgBeginPath()
		nvgCircle(0,0,params.COLON_RADIUS)
		nvgFillColor(minutesColor)
		nvgFill()
		nvgRestore()
		local drawDetailSimple = params.DRAW_DETAIL_SIMPLE
		if drawDetailSimple then drawDetailSimple() end
	else
		digitOffset = math.ceil(params.FONT_SIZE_DIGITS/6)
		seconds = math.floor(milliseconds/1000)
		minutes = math.floor(seconds/60)
		secondsColor = params.FONT_COLOR_SECONDS
		seconds = string.format("%02i",seconds - minutes * 60)
		minutesColor = params.FONT_COLOR_MINUTES
		minutes = string.format("%02i",minutes)
		nvgSave()
		nvgTranslate(0,params.COLON_Y)
		nvgBeginPath()
		thc_drawHexagonPath(params.COLON_BORDER_RADIUS)
		nvgFillColor(params.COLON_BORDER_COLOR)
		nvgFill()
		nvgBeginPath()
		nvgCircle(0,0,params.COLON_RADIUS)
		nvgFillColor(minutesColor)
		nvgFill()
		nvgRestore()
		nvgSave()
		nvgTranslate(0,-params.COLON_Y)
		nvgBeginPath()
		thc_drawHexagonPath(params.COLON_BORDER_RADIUS)
		nvgFillColor(params.COLON_BORDER_COLOR)
		nvgFill()
		nvgBeginPath()
		nvgCircle(0,0,params.COLON_RADIUS)
		nvgFillColor(minutesColor)
		nvgFill()
		nvgRestore()
		local drawDetailSimple = params.DRAW_DETAIL_SIMPLE
		if drawDetailSimple then drawDetailSimple() end
	end
	nvgFontSize(params.FONT_SIZE_DIGITS)
	nvgFontFace(params.FONT_FACE)		
	nvgFontBlur(2)
	nvgFillColor(params.FONT_COLOR_SHADOW)
	nvgTextAlign(NVG_ALIGN_RIGHT,NVG_ALIGN_MIDDLE)
	nvgText(-digitOffset,1,minutes)
	nvgTextAlign(NVG_ALIGN_LEFT,NVG_ALIGN_MIDDLE)
	nvgText(digitOffset,1,seconds)
	nvgFontBlur(0)
	nvgFillColor(minutesColor)
	nvgTextAlign(NVG_ALIGN_RIGHT,NVG_ALIGN_MIDDLE)
	nvgText(-digitOffset,0,minutes)
	nvgFillColor(secondsColor)
	nvgTextAlign(NVG_ALIGN_LEFT,NVG_ALIGN_MIDDLE)
	nvgText(digitOffset,0,seconds)
	nvgRestore()
end

function THC_Clock:draw()
	if not thc_shouldDrawGameHud(true) then return end

	if world.gameState == GAME_STATE_ACTIVE then
		drawClock(world.overTimeCount == 0 and THC_CLOCK.MAIN_TIME(world.gameTimeLimit) or THC_CLOCK.OVERTIME(world.gameTimeLimit),getLocalPlayer().state == PLAYER_STATE_INGAME and consoleGetVariable("ui_thc_clock_ingame"))
	elseif world.gameState == GAME_STATE_WARMUP then
		nvgFontFace(THC_CLOCK.TEXT.FONT_FACE)
		nvgFontSize(THC_CLOCK.TEXT.FONT_SIZE)
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_TOP)
		if world.timerActive then
			nvgFontBlur(4)
			nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR_SHADOW)
			nvgText(0,THC_CLOCK.TEXT.Y,"GAME STARTING...")
			nvgFontBlur(0)
			nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR)
			nvgText(0,THC_CLOCK.TEXT.Y,"GAME STARTING...")
		else
			nvgFontBlur(4)
			nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR_SHADOW)
			nvgText(0,THC_CLOCK.TEXT.Y,"WAITING FOR PLAYERS...")
			nvgFontBlur(0)
			nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR)
			nvgText(0,THC_CLOCK.TEXT.Y,"WAITING FOR PLAYERS...")
		end
	elseif world.gameState == GAME_STATE_GAMEOVER then
		nvgFontFace(THC_CLOCK.TEXT.FONT_FACE)
		nvgFontSize(THC_CLOCK.TEXT.FONT_SIZE)
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_TOP)
		nvgFontBlur(4)
		nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR_SHADOW)
		nvgText(0,THC_CLOCK.TEXT.Y,"GAME OVER")
		nvgFontBlur(0)
		nvgFillColor(THC_CLOCK.TEXT.FONT_COLOR)
		nvgText(0,THC_CLOCK.TEXT.Y,"GAME OVER")
	end
end
