require "base/internal/ui/reflexcore"
require "base/internal/ui/thcHUD/thc_icons"

local clockMainTimeScaledParameters
local clockOvertimeScaledParameters
local killIconThemes

function roundHalfUp(n) return math.floor(n+0.5) end
function roundHalfDown(n) return math.ceil(n-0.5) end

local function defineLiterallyEverything(spacing)

	THC_DEFAULT_SPACING = spacing

	local function colorFactory(r,g,b,a)
		return function(aForce,color,k)
			if not color or not k then
				return Color(r,g,b,aForce*(a or 255)/255)
			else
				return Color(lerp(r,color.r or r,k),lerp(g,color.g or g,k),lerp(b,color.b or b,k),aForce or color.a)
			end
		end
	end

	local function doPanelCalculations(panel)
		if not panel.WIDTH then panel.WIDTH = 0 end
		if not panel.HEIGHT then panel.HEIGHT = 0 end
		if not panel.BORDER then panel.BORDER = 0 end
		if not panel.VALUE_MARGIN then panel.VALUE_MARGIN = 0 end
		if not panel.FONT_FACE then panel.FONT_FACE = THC_FONT_HUD end
		if not panel.FONT_SCALE then panel.FONT_SCALE = 0.75 end
		if not panel.HORIZONTAL_PADDING then panel.HORIZONTAL_PADDING = 0 end
		if not panel.VERTICAL_PADDING then panel.VERTICAL_PADDING = 0 end

		panel.CALC_WIDTH = panel.WIDTH+panel.BORDER
		panel.CALC_HEIGHT = panel.HEIGHT+panel.BORDER
		panel.CALC_VALUE_MARGIN = roundHalfUp(panel.BORDER+panel.VALUE_MARGIN)
		panel.CALC_VALUE_MARGIN_MIDPOINT = panel.BORDER+roundHalfUp(panel.VALUE_MARGIN/2)
		panel.TRUE_WIDTH = panel.WIDTH+panel.BORDER*2
		panel.TRUE_HEIGHT = panel.HEIGHT+panel.BORDER*2
		if not panel.X then panel.X = panel.BORDER*0.5 end
		if not panel.Y then panel.Y = panel.BORDER*0.5 end
		panel.MIDPOINT_X = roundHalfUp(panel.X+(panel.CALC_WIDTH/2))
		panel.MIDPOINT_Y = roundHalfUp(panel.Y+(panel.CALC_HEIGHT/2))
		panel.FONT_SIZE = roundHalfUp(panel.HEIGHT*panel.FONT_SCALE)
		panel.TRUE_X = panel.HORIZONTAL_PADDING
		panel.TRUE_Y = panel.VERTICAL_PADDING
		panel.FULL_WIDTH = panel.TRUE_X + panel.TRUE_WIDTH
		panel.FULL_HEIGHT = panel.TRUE_Y + panel.TRUE_HEIGHT
	end

	local function doClockScaling(clock)
		clock.BORDER_WIDTH = 8
		clock.OUTER_BORDER_WIDTH = 2
		clock.BORDER_EDGE_THICKNESS_FACTOR = 0.25
		clock.VERTICAL_BAR_WIDTH = clock.MAJOR_INTERVAL_WIDTH
		clock.VERTICAL_BAR_SPACING = 1
		clock.VERTICAL_BAR_COUNT = clock.MAJOR_INTERVAL_COUNT
		clock.VERTICAL_BAR_GRADIENT_LOWER_INDEX = 1.7
		clock.VERTICAL_BAR_GRADIENT_UPPER_INDEX = 5
		clock.MAJOR_INTERVAL_MS = clock.TIME_LIMIT/clock.MAJOR_INTERVAL_COUNT
		clock.MAJOR_INTERVAL = clock.MAJOR_INTERVAL_MS/1000
		clock.VERTICAL_BAR_MARGIN = clock.VERTICAL_BAR_SPACING/2
		clock.VERTICAL_BAR_FULL_WIDTH = clock.VERTICAL_BAR_SPACING+clock.VERTICAL_BAR_WIDTH

		clock.INNER_RADIUS = (clock.VERTICAL_BAR_COUNT*clock.VERTICAL_BAR_FULL_WIDTH)/math.sqrt(3)
		clock.INNER_X = -(clock.VERTICAL_BAR_COUNT*clock.VERTICAL_BAR_FULL_WIDTH-clock.VERTICAL_BAR_SPACING)/2
		clock.INNER_Y = -(clock.INNER_RADIUS/2)
		clock.VERTICAL_BAR_HEIGHT = clock.INNER_Y
		clock.INNER_BORDER_RADIUS = clock.INNER_RADIUS+1+clock.VERTICAL_BAR_SPACING
		clock.OUTER_RADIUS = math.ceil(clock.INNER_BORDER_RADIUS + clock.BORDER_WIDTH)
		clock.OUTER_BORDER_RADIUS = clock.OUTER_RADIUS+clock.OUTER_BORDER_WIDTH
		clock.BORDER_RADIUS = (clock.INNER_BORDER_RADIUS+clock.OUTER_RADIUS)/2
		clock.BORDER_EDGE_THICKNESS = clock.OUTER_BORDER_WIDTH*clock.BORDER_EDGE_THICKNESS_FACTOR/clock.OUTER_BORDER_RADIUS
		clock.SUBTEXT_Y = math.ceil(clock.OUTER_RADIUS)+3
		clock.SIMPLE_RADIUS = roundHalfUp(clock.BORDER_RADIUS/2)
		clock.SIMPLE_OUTER_BORDER_RADIUS = roundHalfUp(clock.OUTER_BORDER_RADIUS/2)
		clock.SIMPLE_BORDER_WIDTH = roundHalfUp(clock.OUTER_BORDER_WIDTH/2)+1
		clock.SIMPLE_SUBTEXT_Y = -(math.ceil(clock.SIMPLE_RADIUS)+3)

		clock.COLON_RADIUS = math.ceil(clock.SIMPLE_BORDER_WIDTH*1.2)
		clock.COLON_BORDER_RADIUS = clock.COLON_RADIUS+2
		clock.COLON_Y = math.ceil(clock.COLON_RADIUS*1.7)
		clock.COLON_BORDER_COLOR = THC_COLOR.BLACK(92)

		clock.FONT_SIZE_DIGITS = roundHalfUp(clock.OUTER_BORDER_RADIUS*2*(clock.FONT_SCALE_DIGITS or 0))
		clock.FONT_SIZE_SUBTEXT = roundHalfUp(clock.OUTER_BORDER_RADIUS*2*(clock.FONT_SCALE_SUBTEXT or 0))
		clock.FONT_SIZE_DETAIL = roundHalfUp(clock.INNER_RADIUS*2*(clock.FONT_SCALE_DETAIL or 0))
		clock.FONT_SIZE_DETAIL_SIMPLE = roundHalfUp(clock.BORDER_RADIUS*2*(clock.FONT_SCALE_DETAIL_SIMPLE or 0))
	end

	local function doAwardScaling(award)
		if award.FONT_FACTOR_TEXT then
			award.TEXT_MARGIN = award.SCALE*1
		else
			award.TEXT_MARGIN = 0
		end
		if award.FONT_FACTOR_SUBTEXT then
			award.SUBTEXT_MARGIN = award.SCALE*1
		else
			award.SUBTEXT_MARGIN = 0
		end
		if award.FONT_FACTOR_TEXT and award.FONT_FACTOR_SUBTEXT then
			award.DIVIDER_WIDTH = roundHalfUp(award.SCALE*4)
			award.DIVIDER_HEIGHT = 1
			award.DIVIDER = true
			award.DIVIDER_COLOR = THC_COLOR.TRANSPARENT_WHITE
		else
			award.DIVIDER_WIDTH = 0
			award.DIVIDER_HEIGHT = 0
		end
		award.ICON_MARGIN = award.SCALE*0.5
		award.ICON_RADIUS = award.SCALE*4
		award.ICON_BORDER_THICKNESS = award.SCALE*1
		award.ICON_BORDER_RADIUS = award.ICON_RADIUS + award.ICON_BORDER_THICKNESS

		award.TEXT_X = 0
		award.SUBTEXT_X = 0
		award.FONT_SIZE_SUBTEXT = roundHalfUp(award.SCALE * (award.FONT_FACTOR_SUBTEXT or 0))
		award.FONT_SIZE_TEXT = roundHalfUp(award.SCALE * (award.FONT_FACTOR_TEXT or 0))
		award.TEXT_Y = math.ceil(award.ICON_BORDER_RADIUS + award.ICON_MARGIN)
		award.DIVIDER_X = 0
		award.DIVIDER_Y = math.ceil(award.TEXT_Y + award.TEXT_MARGIN + award.FONT_SIZE_TEXT)-0.5
		award.SUBTEXT_Y = math.ceil(award.DIVIDER_Y + award.DIVIDER_HEIGHT + award.SUBTEXT_MARGIN)
		award.ICON_Y = -math.ceil(award.SUBTEXT_Y + award.FONT_SIZE_SUBTEXT)
		award.FONT_SIZE_COUNTER = award.SCALE*2
		award.COUNTER_RADIUS = award.SCALE*1.5
		award.COUNTER_BORDER_RADIUS = award.SCALE*2
		award.COUNTER_X = math.ceil(award.ICON_BORDER_RADIUS*math.sqrt(3)/2)
		award.COUNTER_Y = -math.ceil(award.ICON_BORDER_RADIUS)
		award.TEXT_ALIGN_H = NVG_ALIGN_CENTER
		award.TEXT_ALIGN_V = NVG_ALIGN_TOP
		award.SUBTEXT_ALIGN_H = NVG_ALIGN_CENTER
		award.SUBTEXT_ALIGN_V = NVG_ALIGN_TOP
	end

	local function doFragMessageScaling(award)
		award.ICON_MARGIN = award.SCALE*0.5
		award.ICON_RADIUS = award.SCALE*2.5
		award.ICON_BORDER_THICKNESS = award.SCALE*1
		award.ICON_BORDER_RADIUS = award.ICON_RADIUS + award.ICON_BORDER_THICKNESS
		if award.FONT_FACTOR_TEXT then
			award.TEXT_MARGIN = award.SCALE*1
		else
			award.TEXT_MARGIN = 0
		end
		if award.FONT_FACTOR_SUBTEXT then
			award.SUBTEXT_MARGIN = award.SCALE*1
		else
			award.SUBTEXT_MARGIN = 0
		end
		award.TEXT_X = -math.ceil(award.ICON_BORDER_RADIUS*1.5)
		award.SUBTEXT_X = math.ceil(award.ICON_BORDER_RADIUS*1.5)
		award.FONT_SIZE_SUBTEXT = roundHalfUp(award.SCALE * (award.FONT_FACTOR_SUBTEXT or 0))
		award.FONT_SIZE_TEXT = roundHalfUp(award.SCALE * (award.FONT_FACTOR_TEXT or 0))
		award.TEXT_Y = 0
		award.SUBTEXT_Y = 0
		award.ICON_Y = 0
		award.TEXT_ALIGN_H = NVG_ALIGN_RIGHT
		award.TEXT_ALIGN_V = NVG_ALIGN_MIDDLE
		award.SUBTEXT_ALIGN_H = NVG_ALIGN_LEFT
		award.SUBTEXT_ALIGN_V = NVG_ALIGN_MIDDLE
		award.COUNTER_BORDER_RADIUS = award.ICON_BORDER_RADIUS*0.5
		award.COUNTER_RADIUS = award.COUNTER_BORDER_RADIUS*0.75
		award.COUNTER_X = (award.COUNTER_X_ALIGN or 1) * math.ceil(award.ICON_BORDER_RADIUS*1.2)
		award.COUNTER_Y = (award.COUNTER_Y_ALIGN or 1) * math.ceil(award.ICON_BORDER_RADIUS*math.sqrt(3)/2)
		award.FONT_SIZE_COUNTER = math.floor(award.COUNTER_RADIUS*1.25)
		award.FRAG_MESSAGE = true
		award.PLUS_ONE_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LIGHTEST
		award.PLUS_ONE_TEXT_COLOR = THC_COLOR.BLACK
		award.MINUS_ONE_BACKGROUND_COLOR = THC_COLOR.RED
		award.MINUS_ONE_TEXT_COLOR = THC_COLOR.WHITE
		award.FULL_SPACED_HEIGHT = (award.ICON_BORDER_RADIUS+award.COUNTER_BORDER_RADIUS+math.abs(award.COUNTER_Y))
	end

	THC_FONT_HUD = "Montserrat-Regular"

	THC_FONT_SIZE_TINY = 16
	THC_FONT_SIZE_SMALL = 24
	THC_FONT_SIZE_BIG = 48
	THC_FONT_SIZE_HUGE = 72
	THC_FONT_SIZE_FUCK_OFF = 96

	THC_COLOR =
	{
		WHITE = colorFactory(0xff,0xff,0xff);
		GREY =
		{
			LIGHT = colorFactory(0xb0,0xb0,0xb0);
			NORMAL = colorFactory(0x80,0x80,0x80);
			DARK = colorFactory(0x30,0x30,0x30);
			DARKER = colorFactory(0x20,0x20,0x20);
			DARKEST = colorFactory(0x10,0x10,0x10);
		};
		BLACK = colorFactory(0x00,0x00,0x00);
		FOREST_GREEN =
		{
			LITERALLY_BLACK = colorFactory(0x03,0x0d,0x07);
			DARKEST = colorFactory(0x01,0x18,0x0c);
			DARK = colorFactory(0x02,0x30,0x17);
			NORMAL = colorFactory(0x03,0x3e,0x1e);
			LIGHT = colorFactory(0x04,0x61,0x2f);
			LIGHTER = colorFactory(0x05,0x78,0x3a);
			LIGHTERER = colorFactory(0x05,0x78,0x3a);
			LIGHTEST = colorFactory(0x19,0xb9,0x62);
		};
		SKY_BLUE = colorFactory(0x00,0xa8,0xff);
		RED = colorFactory(0xdd,0x4d,0x3d);
		ACTUALLY_RED = colorFactory(0x77,0x00,0x00);
		ORANGE = colorFactory(0xed,0x8c,0x12);
		YELLOW = colorFactory(0xfd,0xd2,0x07);
		GREEN = colorFactory(0x2c,0xb4,0x6a);
		MINT = colorFactory(0x7d,0xee,0xb3);
		NOT_GREEN =
		{
			BRIGHT = colorFactory(0xfd,0xd2,0x07);
			THIS_ISNT_YELLOW = colorFactory(0xf1,0xb9,0x12);
			OH_GOD_MY_EYES = colorFactory(0xff,0xff,0x66);
			PROBABLY_ORANGE = colorFactory(0xe5,0x9e,0x16);
			DEFINITELY_ORANGE = colorFactory(0xed,0x8c,0x12);
			MEH_ORANGE = colorFactory(0xbf,0x86,0x30);
			DARK_ORANGE = colorFactory(0x9c,0x61,0x24);
		};
		TRANSPARENT_WHITE = colorFactory(0xff,0xff,0xff,0x80);
		TRANSPARENT_BLACK = colorFactory(0x00,0x00,0x00,0x80);
		LESS_TRANSPARENT_BLACK = colorFactory(0x00,0x00,0x00,0xbb);
		FIRE =
		{
			RED = colorFactory(0xcc,0x00,0x00);
			ORANGE = colorFactory(0xff,0x80,0x00);
			YELLOW = colorFactory(0xff,0xff,0x00);
		}
	}

	THC_HP_SHIT_COLOR = THC_COLOR.FOREST_GREEN.DARK
	THC_HP_NORMAL_COLOR = THC_COLOR.FOREST_GREEN.NORMAL
	THC_HP_BUFF_COLOR = THC_COLOR.FOREST_GREEN.LIGHT

	THC_HEALTH_ICON_CROSS_COLOR = colorFactory(0xff,0xff,0xff)

	THC_PICKUP_COLOR = {}
	THC_PICKUP_COLOR[PICKUP_TYPE_HEALTH100] = THC_COLOR.SKY_BLUE
	THC_PICKUP_COLOR[PICKUP_TYPE_HEALTH50] = THC_COLOR.ORANGE
	THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR150] = THC_COLOR.RED
	THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR100] = THC_COLOR.YELLOW
	THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR50] = THC_COLOR.GREEN

	THC_PICKUP_HEALTH_TYPES = {PICKUP_TYPE_HEALTH100,PICKUP_TYPE_HEALTH50}
	THC_PICKUP_ARMOR_TYPES = {PICKUP_TYPE_ARMOR150,PICKUP_TYPE_ARMOR100,PICKUP_TYPE_ARMOR50}

	THC_BORDER_THIN = 3
	THC_BORDER_FAT = 5
	THC_BORDER_MORBIDLY_OBESE = 10

	THC_ICON_SMALL_RADIUS = 16
	THC_ICON_LARGE_RADIUS = 23

	THC_TIMER_WIDTH = 65
	THC_TIMER_HEIGHT = 65
	THC_TIMER_BORDER = THC_BORDER_FAT
	THC_TIMER_BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_TIMER_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255)
	THC_TIMER_ICON_SPAWNED_WIDTH = 39
	THC_TIMER_ICON_SPAWNED_HEIGHT = 45
	THC_TIMER_ICON_SPAWNED_ALPHA = 255
	THC_TIMER_ICON_TAKEN_WIDTH = 27
	THC_TIMER_ICON_TAKEN_HEIGHT = 31
	THC_TIMER_ICON_TAKEN_ALPHA = 255
	THC_TIMER_FONT_FACE = THC_FONT_HUD

	THC_TIMER_CALC_WIDTH = THC_TIMER_WIDTH+THC_TIMER_BORDER
	THC_TIMER_CALC_HEIGHT = THC_TIMER_HEIGHT+THC_TIMER_BORDER
	THC_TIMER_TRUE_WIDTH = THC_TIMER_WIDTH+THC_TIMER_BORDER*2
	THC_TIMER_TRUE_HEIGHT = THC_TIMER_HEIGHT+THC_TIMER_BORDER*2
	THC_TIMER_X = THC_TIMER_BORDER*0.5
	THC_TIMER_Y = THC_TIMER_BORDER*0.5
	THC_TIMER_MIDPOINT_X = roundHalfUp(THC_TIMER_TRUE_WIDTH/2)
	THC_TIMER_MIDPOINT_Y = roundHalfUp(THC_TIMER_TRUE_HEIGHT/2)
	THC_TIMER_FONT_SIZE = roundHalfUp(THC_TIMER_HEIGHT*2/3)


	THC_METER = {}
	THC_METER.WIDTH = 433
	THC_METER.HEIGHT = 65
	THC_METER.BORDER = THC_BORDER_FAT
	THC_METER.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_METER.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255)
	THC_METER.VALUE_MARGIN = 20
	THC_METER.ICON_MARGIN = 100
	THC_METER.FONT_FACE = THC_FONT_HUD
	THC_METER.FONT_COLOR = THC_COLOR.WHITE(255)
	THC_METER.FONT_SCALE = 2/3
	THC_METER.HORIZONTAL_PADDING = 20 + THC_DEFAULT_SPACING
	doPanelCalculations(THC_METER)
	THC_METER.CALC_ICON_MARGIN = roundHalfUp(THC_METER.TRUE_X+THC_METER.BORDER+THC_METER.ICON_MARGIN+THC_TIMER_ICON_TAKEN_WIDTH/2)


	THC_SPEED = {}
	THC_SPEED.WIDTH = 330
	THC_SPEED.HEIGHT = 28
	THC_SPEED.BORDER = THC_BORDER_THIN
	THC_SPEED.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SPEED.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255)
	THC_SPEED.VALUE_MARGIN = THC_SPEED.WIDTH/2
	THC_SPEED.ICON_MARGIN = 100
	THC_SPEED.FONT_FACE = THC_FONT_HUD
	THC_SPEED.FONT_COLOR = THC_COLOR.WHITE(255)
	THC_SPEED.FONT_SCALE = 2/3
	THC_SPEED.HORIZONTAL_PADDING = 0
	THC_SPEED.VERTICAL_PADDING = 7
	THC_SPEED.TEXT_ALIGN = NVG_ALIGN_CENTER
	doPanelCalculations(THC_SPEED)


	THC_SCORE = {}
	THC_SCORE.WIDTH = 362
	THC_SCORE.HEIGHT = 50
	THC_SCORE.BORDER = THC_BORDER_THIN
	THC_SCORE.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SCORE.ICON_MARGIN = 8
	THC_SCORE.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255)
	doPanelCalculations(THC_SCORE)

	THC_SCORE.METER = {}
	THC_SCORE.METER.HEIGHT = 9
	THC_SCORE.METER.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARK(255)
	THC_SCORE.METER.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SCORE.METER.BORDER = 2

	THC_SCORE.METER.VALUE_MARGIN = 13
	THC_SCORE.METER.FONT_FACE = THC_FONT_HUD
	THC_SCORE.METER.FONT_COLOR = THC_COLOR.WHITE(255)
	THC_SCORE.METER.FONT_SCALE = 2/3
	THC_SCORE.METER.HORIZONTAL_PADDING = -2

	THC_SCORE.CALC_MIDPOINT_Y = roundHalfUp((THC_SCORE.HEIGHT-(THC_SCORE.METER.HEIGHT+THC_SCORE.METER.BORDER))/2)

	THC_SCORE.SPEC_ICON = {}
	THC_SCORE.SPEC_ICON.WIDTH = 50
	THC_SCORE.SPEC_ICON.HEIGHT = 50
	THC_SCORE.SPEC_ICON.BORDER = 2
	THC_SCORE.SPEC_ICON.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SCORE.SPEC_ICON.X = -THC_SCORE.SPEC_ICON.BORDER/2
	THC_SCORE.SPEC_ICON.Y = -THC_SCORE.SPEC_ICON.BORDER/2
	THC_SCORE.SPEC_ICON.ACTIVE_BACKGROUND_COLOR = THC_COLOR.MINT(255)
	THC_SCORE.SPEC_ICON.INACTIVE_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255)
	THC_SCORE.SPEC_ICON.ACTIVE_COLOR = THC_COLOR.BLACK(255)
	THC_SCORE.SPEC_ICON.INACTIVE_COLOR = THC_COLOR.GREY.DARK(255)
	THC_SCORE.SPEC_ICON.RADIUS = roundHalfUp(THC_SCORE.SPEC_ICON.HEIGHT*5/16)
	doPanelCalculations(THC_SCORE.SPEC_ICON)


	THC_SCORE.NETWORK = {}
	THC_SCORE.NETWORK.FONT_SCALE = 0.7
	THC_SCORE.NETWORK.MARGIN_SCALE = 0.2
	THC_SCORE.NETWORK.FONT_SIZE = roundHalfUp(THC_SCORE.SPEC_ICON.HEIGHT*THC_SCORE.NETWORK.FONT_SCALE/2)
	THC_SCORE.NETWORK.MARGIN = roundHalfUp(THC_SCORE.SPEC_ICON.HEIGHT*THC_SCORE.NETWORK.MARGIN_SCALE/2)
	THC_SCORE.NETWORK.PING_Y = roundHalfUp(THC_SCORE.SPEC_ICON.MIDPOINT_Y-THC_SCORE.NETWORK.MARGIN)
	THC_SCORE.NETWORK.PACKETLOSS_Y = roundHalfUp(THC_SCORE.SPEC_ICON.MIDPOINT_Y+THC_SCORE.NETWORK.MARGIN)
	THC_SCORE.NETWORK.FONT_FACE = THC_FONT_HUD
	THC_SCORE.NETWORK.FONT_COLOR_GOOD = THC_COLOR.GREEN(255)
	THC_SCORE.NETWORK.FONT_COLOR_BAD = THC_COLOR.RED(255)
	THC_SCORE.NETWORK.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255)
	THC_SCORE.NETWORK.X = roundHalfUp(THC_SCORE.SPEC_ICON.CALC_WIDTH+THC_SCORE.SPEC_ICON.MIDPOINT_X)


	THC_SCORE.DIFFERENCE = {}
	THC_SCORE.DIFFERENCE.HEIGHT = (THC_SCORE.METER.HEIGHT + THC_SCORE.BORDER)*2+THC_DEFAULT_SPACING
	THC_SCORE.DIFFERENCE.Y = THC_SCORE.TRUE_HEIGHT-THC_SCORE.METER.HEIGHT-THC_SCORE.BORDER
	THC_SCORE.DIFFERENCE.COLOR_TARGET = THC_COLOR.YELLOW(255,THC_COLOR.RED(255),0.3)
	THC_SCORE.DIFFERENCE.COLOR_TARGET_LEAD = THC_COLOR.YELLOW(255,THC_COLOR.GREEN(255),0.3)
	THC_SCORE.DIFFERENCE.COLOR_TARGET_TIE = THC_COLOR.YELLOW(255,THC_COLOR.GREY.NORMAL(255),0.3)
	THC_SCORE.DIFFERENCE.COLOR_BEHIND = THC_COLOR.RED(255,THC_COLOR.BLACK(255),0.4)
	THC_SCORE.DIFFERENCE.COLOR_AHEAD = THC_COLOR.GREEN(255,THC_COLOR.BLACK(255),0.4)
	THC_SCORE.DIFFERENCE.COLOR_EQUAL = THC_COLOR.GREY.NORMAL(255,THC_COLOR.BLACK(255),0.4)
	THC_SCORE.DIFFERENCE.FONT_SCALE = 0.8
	THC_SCORE.DIFFERENCE.FONT_SIZE = roundHalfUp(THC_SCORE.DIFFERENCE.HEIGHT*THC_SCORE.DIFFERENCE.FONT_SCALE)
	THC_SCORE.DIFFERENCE.FONT_FACE = THC_FONT_HUD
	nvgSave()
	nvgFontSize(THC_SCORE.DIFFERENCE.FONT_SIZE)
	nvgFontFace(THC_SCORE.DIFFERENCE.FONT_FACE)
	THC_SCORE.DIFFERENCE.SYMBOL_WIDTH = math.ceil(math.max(nvgTextWidth("+"),nvgTextWidth("-")))
	THC_SCORE.DIFFERENCE.TIE_WIDTH = nvgTextWidth("TIE")
	nvgRestore()
	THC_SCORE.DIFFERENCE.SYMBOL_MARGIN_SCALE = 0.1
	THC_SCORE.DIFFERENCE.SYMBOL_MARGIN = THC_SCORE.DIFFERENCE.SYMBOL_MARGIN_SCALE*THC_SCORE.DIFFERENCE.SYMBOL_WIDTH
	THC_SCORE.DIFFERENCE.FONT_COLOR = THC_COLOR.WHITE(128)


	THC_SCORE.VALUE = {}
	THC_SCORE.VALUE.WIDTH = 60
	THC_SCORE.VALUE.BORDER = 2
	THC_SCORE.VALUE.MARGIN = 8
	THC_SCORE.VALUE.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SCORE.VALUE.HEIGHT = 50
	THC_SCORE.VALUE.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255)
	THC_SCORE.VALUE.X = THC_SCORE.WIDTH-THC_SCORE.VALUE.WIDTH-THC_SCORE.VALUE.BORDER/2
	THC_SCORE.VALUE.Y = -THC_SCORE.VALUE.BORDER/2
	THC_SCORE.VALUE.FONT_SCALE = 0.75
	THC_SCORE.VALUE.FONT_FACE = THC_FONT_HUD
	THC_SCORE.VALUE.FONT_COLOR = THC_COLOR.WHITE(255)
	doPanelCalculations(THC_SCORE.VALUE)
	THC_SCORE.VALUE.FONT_COLOR_READY = THC_COLOR.MINT(255)
	THC_SCORE.VALUE.FONT_COLOR_NOT_READY = THC_COLOR.GREY.DARK(255)
	nvgSave()
	nvgFontSize(THC_SCORE.VALUE.FONT_SIZE)
	nvgFontFace(THC_SCORE.VALUE.FONT_FACE)
	THC_SCORE.VALUE.READY_WIDTH = nvgTextWidth("READY")
	THC_SCORE.VALUE.FONT_SIZE_WARMUP = math.floor(math.min(THC_SCORE.VALUE.FONT_SIZE,math.floor(THC_SCORE.VALUE.FONT_SIZE*(THC_SCORE.VALUE.WIDTH-THC_SCORE.VALUE.MARGIN*2)/THC_SCORE.VALUE.READY_WIDTH)))
	THC_SCORE.VALUE.MINUS_WIDTH = nvgTextWidth("-")
	THC_SCORE.VALUE.NEGATIVE_X = roundHalfUp(THC_SCORE.VALUE.MIDPOINT_X-THC_SCORE.VALUE.MINUS_WIDTH/2)
	nvgRestore()

	THC_SCORE.DIFFERENCE.LEFT_BORDER_X = -THC_SCORE.BORDER-THC_SCORE.VALUE.CALC_WIDTH+THC_SCORE.VALUE.BORDER/2
	THC_SCORE.DIFFERENCE.MIDPOINT_X = roundHalfUp(-THC_SCORE.BORDER/2-THC_SCORE.VALUE.CALC_WIDTH/2)
	THC_SCORE.DIFFERENCE.VALUE_X = roundHalfUp(-THC_SCORE.BORDER/2-THC_SCORE.VALUE.CALC_WIDTH/2-THC_SCORE.DIFFERENCE.SYMBOL_WIDTH/2)


	THC_SCORE.METER.WIDTH = (THC_SCORE.WIDTH - (THC_SCORE.SPEC_ICON.CALC_WIDTH + THC_SCORE.VALUE.CALC_WIDTH))/2
	doPanelCalculations(THC_SCORE.METER)

	THC_SCORE.METER.OFFSET_X = THC_SCORE.SPEC_ICON.CALC_WIDTH + THC_SCORE.METER.CALC_WIDTH + THC_SCORE.METER.HORIZONTAL_PADDING
	THC_SCORE.METER.OFFSET_Y = THC_SCORE.HEIGHT+THC_SCORE.METER.BORDER
	THC_SCORE.METER.SCALE_X = THC_SCORE.METER.TRUE_WIDTH/THC_METER.TRUE_WIDTH
	THC_SCORE.METER.SCALE_Y = THC_SCORE.METER.TRUE_HEIGHT/THC_METER.TRUE_HEIGHT

	THC_SCORE.VALUE.SCORE_Y_LEAD = roundHalfUp(THC_SCORE.VALUE.Y+(THC_SCORE.VALUE.CALC_HEIGHT-THC_SCORE.METER.CALC_HEIGHT)/2)
	THC_SCORE.VALUE.SCORE_Y_TAIL = roundHalfUp(THC_SCORE.VALUE.Y+(THC_SCORE.METER.CALC_HEIGHT+THC_SCORE.VALUE.CALC_HEIGHT)/2)

	THC_SCORE.NAME = {}
	THC_SCORE.NAME.MARGIN = 40
	THC_SCORE.NAME.X = THC_SCORE.WIDTH-THC_SCORE.VALUE.CALC_WIDTH-THC_SCORE.NAME.MARGIN
	THC_SCORE.NAME.Y = THC_SCORE.CALC_MIDPOINT_Y
	THC_SCORE.NAME.FONT_SCALE = 0.8
	THC_SCORE.NAME.FONT_FACE = THC_FONT_HUD
	THC_SCORE.NAME.FONT_COLOR = THC_COLOR.WHITE(255)
	THC_SCORE.NAME.HEIGHT = THC_SCORE.HEIGHT-THC_SCORE.METER.TRUE_HEIGHT
	THC_SCORE.NAME.WIDTH = THC_SCORE.METER.WIDTH*2-THC_SCORE.NAME.MARGIN*2
	doPanelCalculations(THC_SCORE.NAME)

	THC_SCORE.ICON_RADIUS = 10

	THC_SCORE.HEALTH_ICON = {}
	THC_SCORE.HEALTH_ICON.X = THC_SCORE.SPEC_ICON.WIDTH + 8 + THC_SCORE.ICON_RADIUS
	THC_SCORE.HEALTH_ICON.Y = THC_SCORE.CALC_MIDPOINT_Y
	THC_SCORE.HEALTH_ICON.ACTIVE_COLOR = THC_PICKUP_COLOR[PICKUP_TYPE_HEALTH100]
	THC_SCORE.HEALTH_ICON.INACTIVE_COLOR = THC_COLOR.GREY.DARK

	THC_SCORE.ARMOR_ICON = {}
	THC_SCORE.ARMOR_ICON.X = THC_SCORE.WIDTH-THC_SCORE.VALUE.CALC_WIDTH - 8 - THC_SCORE.ICON_RADIUS
	THC_SCORE.ARMOR_ICON.Y = THC_SCORE.CALC_MIDPOINT_Y
	THC_SCORE.ARMOR_ICON.COLOR =
	{
		THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR50](255);
		THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR100](255);
		THC_PICKUP_COLOR[PICKUP_TYPE_ARMOR150](255);
	}


	THC_SPEC = {}
	THC_SPEC.WIDTH = 220
	THC_SPEC.HEIGHT = 30
	THC_SPEC.BORDER = THC_BORDER_THIN
	THC_SPEC.BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_SPEC.BORDER_COLOR_NOTQUEUED = THC_COLOR.BLACK(255)
	THC_SPEC.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255)
	THC_SPEC.BACKGROUND_COLOR_NOTQUEUED = THC_COLOR.GREY.DARKER(255)
	doPanelCalculations(THC_SPEC)
	THC_SPEC.X_OFFSET = 0

	THC_SPEC.VALUE = {}
	THC_SPEC.VALUE.WIDTH = 30
	THC_SPEC.VALUE.HEIGHT = THC_SPEC.HEIGHT
	THC_SPEC.VALUE.MARGIN = 3
	THC_SPEC.VALUE.BORDER = THC_SPEC.BORDER
	THC_SPEC.VALUE.BACKGROUND_COLOR = THC_COLOR.BLACK(255)
	THC_SPEC.VALUE.X = 0
	THC_SPEC.VALUE.Y = THC_SPEC.Y
	THC_SPEC.VALUE.FONT_SCALE = 0.75
	THC_SPEC.VALUE.FONT_FACE = THC_FONT_HUD
	THC_SPEC.VALUE.FONT_COLOR = THC_COLOR.GREY.NORMAL(255)
	doPanelCalculations(THC_SPEC.VALUE)

	THC_SPEC.NAME = {}
	THC_SPEC.NAME.MARGIN = 7
	THC_SPEC.NAME.X = THC_SPEC.VALUE.TRUE_WIDTH+THC_SPEC.NAME.MARGIN
	THC_SPEC.NAME.Y = THC_SPEC.MIDPOINT_Y
	THC_SPEC.NAME.FONT_SCALE = 0.75
	THC_SPEC.NAME.FONT_FACE = THC_FONT_HUD
	THC_SPEC.NAME.FONT_COLOR = THC_COLOR.GREY.NORMAL(255)
	THC_SPEC.NAME.HEIGHT = THC_SPEC.HEIGHT
	THC_SPEC.NAME.WIDTH = THC_SPEC.WIDTH-THC_SPEC.VALUE.TRUE_WIDTH-THC_SPEC.NAME.MARGIN*2
	doPanelCalculations(THC_SPEC.NAME)

	THC_SPEC.LABEL = {}
	THC_SPEC.LABEL.FONT_SIZE = THC_SPEC.NAME.FONT_SIZE
	THC_SPEC.LABEL.FONT_FACE = THC_FONT_HUD
	THC_SPEC.LABEL.FONT_COLOR_QUEUED = THC_COLOR.FOREST_GREEN.NORMAL(255)
	THC_SPEC.LABEL.FONT_COLOR_SPECTATOR = THC_COLOR.GREY.NORMAL(255)
	THC_SPEC.LABEL.FONT_COLOR_SHADOW = THC_COLOR.BLACK(255)

	THC_GAMEOVER =
	{
		WIDTH = 300;
		HEIGHT = 50;
		BORDER = THC_BORDER_THIN;
		BORDER_COLOR = THC_COLOR.BLACK(255);
		BACKGROUND_COLOR_WIN = THC_COLOR.FOREST_GREEN.DARK(255);
		BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255);
	}
	doPanelCalculations(THC_GAMEOVER)

	THC_GAMEOVER.VALUE =
	{
		WIDTH = 60;
		BORDER = 2;
		MARGIN = 8;
		BORDER_COLOR = THC_COLOR.BLACK(255);
		HEIGHT = 50;
		BACKGROUND_COLOR_WIN = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255);
		BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LITERALLY_BLACK(255);
		FONT_SCALE = 0.75;
		FONT_FACE = THC_FONT_HUD;
		FONT_COLOR = THC_COLOR.WHITE(255);
		FONT_COLOR_WIN = THC_COLOR.WHITE(255)
	}
	THC_GAMEOVER.VALUE.X = THC_GAMEOVER.WIDTH-THC_GAMEOVER.VALUE.WIDTH-THC_GAMEOVER.VALUE.BORDER/2;
	THC_GAMEOVER.VALUE.Y = -THC_GAMEOVER.VALUE.BORDER/2;
	doPanelCalculations(THC_GAMEOVER.VALUE)

	THC_GAMEOVER.NAME = {}
	THC_GAMEOVER.NAME.MARGIN = 40
	THC_GAMEOVER.NAME.X = (THC_GAMEOVER.WIDTH-THC_GAMEOVER.VALUE.CALC_WIDTH)/2
	THC_GAMEOVER.NAME.Y = roundHalfUp(THC_GAMEOVER.HEIGHT/2)
	THC_GAMEOVER.NAME.FONT_SCALE = 0.8
	THC_GAMEOVER.NAME.FONT_FACE = THC_FONT_HUD
	THC_GAMEOVER.NAME.FONT_COLOR = THC_COLOR.WHITE(255)
	THC_GAMEOVER.NAME.FONT_COLOR_WIN = THC_COLOR.WHITE(255)
	THC_GAMEOVER.NAME.HEIGHT = THC_GAMEOVER.HEIGHT
	THC_GAMEOVER.NAME.WIDTH = THC_GAMEOVER.WIDTH-THC_GAMEOVER.VALUE.WIDTH-THC_GAMEOVER.NAME.MARGIN*2
	doPanelCalculations(THC_GAMEOVER.NAME)

	THC_GAMEOVER.DIFFERENCE = {}
	THC_GAMEOVER.DIFFERENCE.HEIGHT = (THC_SCORE.METER.HEIGHT + THC_GAMEOVER.BORDER)*2+1
	THC_GAMEOVER.DIFFERENCE.Y = THC_GAMEOVER.TRUE_HEIGHT-THC_SCORE.METER.HEIGHT-THC_GAMEOVER.BORDER
	THC_GAMEOVER.DIFFERENCE.COLOR_WINNER = THC_COLOR.MINT(255)
	THC_GAMEOVER.DIFFERENCE.COLOR_EQUAL = THC_COLOR.GREY.LIGHT(255)
	THC_GAMEOVER.DIFFERENCE.FONT_SCALE = 0.8
	THC_GAMEOVER.DIFFERENCE.FONT_SIZE = roundHalfUp(THC_GAMEOVER.DIFFERENCE.HEIGHT*THC_GAMEOVER.DIFFERENCE.FONT_SCALE)
	THC_GAMEOVER.DIFFERENCE.FONT_FACE = THC_FONT_HUD
	nvgSave()
	nvgFontSize(THC_GAMEOVER.DIFFERENCE.FONT_SIZE)
	nvgFontFace(THC_GAMEOVER.DIFFERENCE.FONT_FACE)
	THC_GAMEOVER.DIFFERENCE.SYMBOL_WIDTH = math.ceil(nvgTextWidth("+"))
	THC_GAMEOVER.DIFFERENCE.TIE_WIDTH = nvgTextWidth("TIE")
	nvgRestore()
	THC_GAMEOVER.DIFFERENCE.SYMBOL_MARGIN_SCALE = 0.1
	THC_GAMEOVER.DIFFERENCE.SYMBOL_MARGIN = THC_GAMEOVER.DIFFERENCE.SYMBOL_MARGIN_SCALE*THC_GAMEOVER.DIFFERENCE.SYMBOL_WIDTH
	THC_GAMEOVER.DIFFERENCE.FONT_COLOR = THC_COLOR.GREY.DARKER(196)
	THC_GAMEOVER.DIFFERENCE.LEFT_BORDER_X = -THC_GAMEOVER.BORDER-THC_GAMEOVER.VALUE.CALC_WIDTH+THC_GAMEOVER.VALUE.BORDER/2
	THC_GAMEOVER.DIFFERENCE.MIDPOINT_X = roundHalfUp(-THC_GAMEOVER.BORDER/2-THC_GAMEOVER.VALUE.CALC_WIDTH/2)
	THC_GAMEOVER.DIFFERENCE.VALUE_X = roundHalfUp(-THC_GAMEOVER.BORDER/2-THC_GAMEOVER.VALUE.CALC_WIDTH/2-THC_GAMEOVER.DIFFERENCE.SYMBOL_WIDTH/2)

	THC_GAMEOVER.VALUE.SCORE_Y_LEAD = roundHalfUp(THC_GAMEOVER.VALUE.Y+(THC_GAMEOVER.VALUE.CALC_HEIGHT-THC_SCORE.METER.CALC_HEIGHT)/2)
	THC_GAMEOVER.VALUE.SCORE_Y_TAIL = roundHalfUp(THC_GAMEOVER.VALUE.Y+(THC_SCORE.METER.CALC_HEIGHT+THC_GAMEOVER.VALUE.CALC_HEIGHT)/2)


	THC_CLOCK = {}
	clockMainTimeScaledParameters = {}
	clockOvertimeScaledParameters = {}

	function THC_CLOCK.MAIN_TIME(timeLimit)
		if timeLimit < 0 or not timeLimit then return end
		if not clockMainTimeScaledParameters[timeLimit] then
			local params = {}
			params.TIME_LIMIT = timeLimit
			params.MAJOR_INTERVAL_COUNT = 10
			params.MAJOR_INTERVAL_WIDTH = 3
			params.FONT_SCALE_DIGITS = 0.7
			doClockScaling(params)

			params.VERTICAL_BAR_COLOR_EMPTY_FACTORY = THC_COLOR.FOREST_GREEN.LIGHTEST
			params.VERTICAL_BAR_COLOR_FULL_FACTORY = THC_COLOR.GREY.DARK
			params.VERTICAL_BAR_COLOR_CURRENT_FACTORY = THC_COLOR.MINT
			params.VERTICAL_BAR_COLOR_FULL = params.VERTICAL_BAR_COLOR_FULL_FACTORY(255)
			params.VERTICAL_BAR_COLOR_CURRENT = params.VERTICAL_BAR_COLOR_CURRENT_FACTORY(255)
			params.VERTICAL_BAR_COLOR_EMPTY = params.VERTICAL_BAR_COLOR_EMPTY_FACTORY(255)
			params.VERTICAL_BAR_COLOR_BACKGROUND = THC_COLOR.GREY.DARKER(255)

			params.VERTICAL_BAR_TRANSITION_TIME = params.MAJOR_INTERVAL/10
			params.VERTICAL_BAR_TRANSITION_THRESHOLD = params.MAJOR_INTERVAL - params.VERTICAL_BAR_TRANSITION_TIME
			params.VERTICAL_BAR_TRANSITION_TIME_MS = params.VERTICAL_BAR_TRANSITION_TIME * 1000
			params.VERTICAL_BAR_TRANSITION_THRESHOLD_MS = params.VERTICAL_BAR_TRANSITION_THRESHOLD * 1000

			params.BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARK(255)
			params.FOREGROUND_COLOR = THC_COLOR.FOREST_GREEN.LIGHT(255)
			params.OUTER_BORDER_COLOR = THC_COLOR.GREY.DARKER(255)

			params.FONT_FACE = THC_FONT_HUD
			params.FONT_COLOR_SHADOW = THC_COLOR.BLACK(255)
			params.FONT_COLOR_MINUTES = THC_COLOR.FOREST_GREEN.LIGHTEST(255)
			params.FONT_COLOR_SECONDS = THC_COLOR.FOREST_GREEN.LIGHTEST(255)
			params.FONT_COLOR_SECONDS_XX = THC_COLOR.FOREST_GREEN.LIGHTERER(255)

			params.DRAW_DETAIL = function (milliseconds)
				nvgBeginPath()
				thc_drawHexagonPath(params.OUTER_BORDER_RADIUS)
				nvgFillColor(params.OUTER_BORDER_COLOR)
				nvgFill()
				nvgBeginPath()
				thc_drawHexagonPath(params.OUTER_RADIUS)
				nvgFillColor(params.BACKGROUND_COLOR)
				nvgFill()
				nvgFillColor(params.FOREGROUND_COLOR)
				thc_angleFill(params.OUTER_RADIUS*2,0.5*math.pi,-(milliseconds % params.MAJOR_INTERVAL_MS)*2*math.pi/params.MAJOR_INTERVAL_MS)
				millseconds = milliseconds + 999
				local secondsElapsed = math.floor(milliseconds/1000)
				local minutesElapsed = math.floor(secondsElapsed/params.MAJOR_INTERVAL)
				secondsElapsed = secondsElapsed - minutesElapsed * params.MAJOR_INTERVAL
				nvgBeginPath()
				thc_drawHexagonPath(params.INNER_RADIUS)
				nvgFillColor(params.VERTICAL_BAR_COLOR_BACKGROUND)
				nvgFill()
				nvgStrokeWidth(params.OUTER_BORDER_WIDTH*1.5)
				nvgStrokeColor(params.VERTICAL_BAR_COLOR_BACKGROUND)
				nvgStroke()
				nvgFillColor(params.VERTICAL_BAR_COLOR_FULL)
				for m=0,minutesElapsed-1 do
					nvgScissor(params.INNER_X + m*(params.VERTICAL_BAR_FULL_WIDTH),-params.INNER_RADIUS,params.VERTICAL_BAR_WIDTH,params.INNER_RADIUS*2)
					nvgFill()
					nvgResetScissor()
				end
				if secondsElapsed >= params.VERTICAL_BAR_TRANSITION_THRESHOLD and secondsElapsed < params.MAJOR_INTERVAL then
					nvgFillLinearGradient(0,-(params.INNER_Y-(((minutesElapsed+1)<=(params.VERTICAL_BAR_COUNT/2)) and (((params.VERTICAL_BAR_COUNT/2)-(minutesElapsed+1))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT) or (((minutesElapsed+1)-(params.VERTICAL_BAR_COUNT/2))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT))),
								0,params.INNER_Y-(((minutesElapsed+1)<=(params.VERTICAL_BAR_COUNT/2)) and (((params.VERTICAL_BAR_COUNT/2)-(minutesElapsed+1))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT) or (((minutesElapsed+1)-(params.VERTICAL_BAR_COUNT/2))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT)),
								params.VERTICAL_BAR_COLOR_CURRENT_FACTORY(255,params.VERTICAL_BAR_COLOR_FULL,math.max(0,math.min(1,((milliseconds%params.MAJOR_INTERVAL_MS)-params.VERTICAL_BAR_TRANSITION_THRESHOLD_MS)/params.VERTICAL_BAR_TRANSITION_TIME_MS))^(params.VERTICAL_BAR_GRADIENT_LOWER_INDEX)),
								params.VERTICAL_BAR_COLOR_CURRENT_FACTORY(255,params.VERTICAL_BAR_COLOR_FULL,math.max(0,math.min(1,((milliseconds%params.MAJOR_INTERVAL_MS)-params.VERTICAL_BAR_TRANSITION_THRESHOLD_MS)/params.VERTICAL_BAR_TRANSITION_TIME_MS))^(params.VERTICAL_BAR_GRADIENT_UPPER_INDEX)))
				elseif params.MAJOR_INTERVAL-secondsElapsed >= params.VERTICAL_BAR_TRANSITION_THRESHOLD then
					nvgFillLinearGradient(0,-(params.INNER_Y-(((minutesElapsed+1)<=(params.VERTICAL_BAR_COUNT/2)) and (((params.VERTICAL_BAR_COUNT/2)-(minutesElapsed+1))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT) or (((minutesElapsed+1)-(params.VERTICAL_BAR_COUNT/2))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT))),
								0,params.INNER_Y-(((minutesElapsed+1)<=(params.VERTICAL_BAR_COUNT/2)) and (((params.VERTICAL_BAR_COUNT/2)-(minutesElapsed+1))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT) or (((minutesElapsed+1)-(params.VERTICAL_BAR_COUNT/2))*(params.INNER_Y)/params.VERTICAL_BAR_COUNT)),
								params.VERTICAL_BAR_COLOR_CURRENT_FACTORY(255,params.VERTICAL_BAR_COLOR_EMPTY,math.max(0,math.min(1,((params.MAJOR_INTERVAL_MS-(milliseconds%params.MAJOR_INTERVAL_MS))-params.VERTICAL_BAR_TRANSITION_THRESHOLD_MS)/params.VERTICAL_BAR_TRANSITION_TIME_MS))^(params.VERTICAL_BAR_GRADIENT_LOWER_INDEX)),
								params.VERTICAL_BAR_COLOR_CURRENT_FACTORY(255,params.VERTICAL_BAR_COLOR_EMPTY,math.max(0,math.min(1,((params.MAJOR_INTERVAL_MS-(milliseconds%params.MAJOR_INTERVAL_MS))-params.VERTICAL_BAR_TRANSITION_THRESHOLD_MS)/params.VERTICAL_BAR_TRANSITION_TIME_MS))^(params.VERTICAL_BAR_GRADIENT_UPPER_INDEX)))
				else
					nvgFillColor(params.VERTICAL_BAR_COLOR_CURRENT)
				end
				nvgScissor(params.INNER_X + minutesElapsed*(params.VERTICAL_BAR_FULL_WIDTH),-params.INNER_RADIUS,params.VERTICAL_BAR_WIDTH,params.INNER_RADIUS*2)
				nvgFill()
				nvgResetScissor()
				nvgFillColor(params.VERTICAL_BAR_COLOR_EMPTY)
				for m=minutesElapsed+1,params.VERTICAL_BAR_COUNT-1 do
					nvgScissor(params.INNER_X + m*(params.VERTICAL_BAR_FULL_WIDTH),-params.INNER_RADIUS,params.VERTICAL_BAR_WIDTH,params.INNER_RADIUS*2)
					nvgFill()
					nvgResetScissor()
				end
			end

			clockMainTimeScaledParameters[timeLimit] = params
		end
		return clockMainTimeScaledParameters[timeLimit]
	end

	function THC_CLOCK.OVERTIME(timeLimit)
		if timeLimit < 0 or not timeLimit then return end
		if not clockOvertimeScaledParameters[timeLimit] then
			local params = {}
			params.TIME_LIMIT = timeLimit
			params.MAJOR_INTERVAL_COUNT = 1
			params.MAJOR_INTERVAL_WIDTH = 39
			params.FONT_SCALE_DIGITS = 0.7
			params.FONT_SCALE_SUBTEXT = 0.35
			params.FONT_SCALE_DETAIL = 0.8
			params.FONT_SCALE_DETAIL_SIMPLE = 0.455
			doClockScaling(params)

			params.DETAIL_GLOW_THRESHOLD_FACTOR = 0.03
			params.DETAIL_GLOW_INDEX = 10
			params.DETAIL_COLOR_BACKGROUND_FACTORY = THC_COLOR.GREY.DARKER
			params.DETAIL_COLOR_BACKGROUND = params.DETAIL_COLOR_BACKGROUND_FACTORY(255)
			params.SIMPLE_DETAIL_COLOR_BACKGROUND_FACTORY = THC_COLOR.GREY.DARK
			params.SIMPLE_DETAIL_COLOR_BACKGROUND = params.SIMPLE_DETAIL_COLOR_BACKGROUND_FACTORY(255)
			params.DETAIL_COLOR_GLOW = THC_COLOR.NOT_GREEN.OH_GOD_MY_EYES(255)
			params.DETAIL_GLOW_THRESHOLD = params.MAJOR_INTERVAL*params.DETAIL_GLOW_THRESHOLD_FACTOR
			params.DETAIL_GLOW_THRESHOLD_MS = params.DETAIL_GLOW_THRESHOLD * 1000

			params.FOREGROUND_COLOR = THC_COLOR.NOT_GREEN.THIS_ISNT_YELLOW(255)
			params.BACKGROUND_COLOR = THC_COLOR.NOT_GREEN.DARK_ORANGE(255)
			params.OUTER_BORDER_COLOR = THC_COLOR.GREY.DARKER(255)

			params.FONT_FACE = THC_FONT_HUD
			params.FONT_COLOR_SHADOW = THC_COLOR.BLACK(255)
			params.FONT_COLOR_MINUTES = THC_COLOR.NOT_GREEN.BRIGHT(255)
			params.FONT_COLOR_SECONDS = THC_COLOR.NOT_GREEN.BRIGHT(255)
			params.FONT_COLOR_SECONDS_XX = THC_COLOR.NOT_GREEN.THIS_ISNT_YELLOW(255)
			params.FONT_COLOR_DETAIL = THC_COLOR.NOT_GREEN.DEFINITELY_ORANGE(255)
			params.FONT_COLOR_DETAIL_GLOW = THC_COLOR.NOT_GREEN.OH_GOD_MY_EYES(255)
			params.FONT_COLOR_SUBTEXT = THC_COLOR.NOT_GREEN.DEFINITELY_ORANGE(255)

			params.DRAW_DETAIL = function (milliseconds)
				nvgBeginPath()
				thc_drawHexagonPath(params.OUTER_BORDER_RADIUS)
				nvgFillColor(params.OUTER_BORDER_COLOR)
				nvgFill()
				nvgBeginPath()
				thc_drawHexagonPath(params.OUTER_RADIUS)
				nvgFillColor(params.BACKGROUND_COLOR)
				nvgFill()
				nvgFillColor(params.FOREGROUND_COLOR)
				thc_angleFill(params.OUTER_RADIUS*2,0.5*math.pi,-(milliseconds % params.MAJOR_INTERVAL_MS)*2*math.pi/params.MAJOR_INTERVAL_MS)
				nvgBeginPath()
				thc_drawHexagonPath(params.INNER_RADIUS)
				local secondsElapsed = math.floor(milliseconds/1000)
				local minutesElapsed = math.floor(secondsElapsed/params.MAJOR_INTERVAL)
				secondsElapsed = secondsElapsed - minutesElapsed * params.MAJOR_INTERVAL
				if minutesElapsed == 0 and milliseconds%params.MAJOR_INTERVAL_MS < params.DETAIL_GLOW_THRESHOLD_MS then
					nvgFillColor(params.DETAIL_COLOR_BACKGROUND_FACTORY(255,params.DETAIL_COLOR_GLOW,(1-math.max(0,math.min(1,(milliseconds%params.MAJOR_INTERVAL_MS)/params.DETAIL_GLOW_THRESHOLD_MS)))^(params.DETAIL_GLOW_INDEX)))
					nvgStrokeColor(params.DETAIL_COLOR_BACKGROUND_FACTORY(255,params.DETAIL_COLOR_GLOW,(1-math.max(0,math.min(1,(milliseconds%params.MAJOR_INTERVAL_MS)/params.DETAIL_GLOW_THRESHOLD_MS)))^(params.DETAIL_GLOW_INDEX)))
				else
					nvgFillColor(params.DETAIL_COLOR_BACKGROUND)
					nvgStrokeColor(params.DETAIL_COLOR_BACKGROUND)
				end
				nvgFill()
				nvgStrokeWidth(params.OUTER_BORDER_WIDTH*1.5)
				nvgStroke()
				nvgFontFace(params.FONT_FACE)
				nvgFontSize(params.FONT_SIZE_DETAIL)
				nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
				nvgFontBlur(20)
				nvgFillColor(params.FONT_COLOR_DETAIL_GLOW)
				nvgText(0,0,world.overTimeCount)
				nvgFontBlur(0)
				nvgFillColor(params.FONT_COLOR_DETAIL)
				nvgText(0,0,world.overTimeCount)
				nvgFontSize(params.FONT_SIZE_SUBTEXT)
				nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_TOP)
				nvgFontBlur(2)
				nvgFillColor(params.FONT_COLOR_SHADOW)
				nvgText(0,params.SUBTEXT_Y+1,"OVERTIME")
				nvgFontBlur(0)
				nvgFillColor(params.FONT_COLOR_SUBTEXT)
				nvgText(0,params.SUBTEXT_Y,"OVERTIME")
			end

			params.DRAW_DETAIL_SIMPLE = function ()
				nvgSave()
				nvgFontFace(params.FONT_FACE)
				nvgFontSize(params.FONT_SIZE_SUBTEXT)
				nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_BOTTOM)
				nvgFontBlur(2)
				nvgFillColor(params.FONT_COLOR_SHADOW)
				nvgText(0,params.SIMPLE_SUBTEXT_Y+1,"OVERTIME×"..world.overTimeCount)
				nvgFontBlur(0)
				nvgFillColor(params.FONT_COLOR_SUBTEXT)
				nvgText(0,params.SIMPLE_SUBTEXT_Y,"OVERTIME×"..world.overTimeCount)
				nvgRestore()
			end

			clockOvertimeScaledParameters[timeLimit] = params
		end
		return clockOvertimeScaledParameters[timeLimit]
	end

	-- Precalculations
	THC_CLOCK.MAIN_TIME(0)		-- 00:00 (warmup/gameover)
	THC_CLOCK.MAIN_TIME(10000)	-- 00:10 (countdown)
	THC_CLOCK.MAIN_TIME(60000)	-- 01:00
	THC_CLOCK.MAIN_TIME(600000)	-- 10:00 (duel)

	THC_CLOCK.OVERTIME(120000)	-- 02:00 (overtime)

	THC_CLOCK.TEXT = {}
	THC_CLOCK.TEXT.Y = THC_CLOCK.OVERTIME(120000,600000).SUBTEXT_Y
	THC_CLOCK.TEXT.FONT_SIZE = roundHalfUp(THC_CLOCK.OVERTIME(120000,600000).FONT_SIZE_SUBTEXT*1.5)
	THC_CLOCK.TEXT.FONT_FACE = THC_FONT_HUD
	THC_CLOCK.TEXT.FONT_COLOR = THC_COLOR.GREY.LIGHT(255)
	THC_CLOCK.TEXT.FONT_COLOR_SHADOW = THC_COLOR.BLACK(255)

	THC_COUNTDOWN_STRING_FIGHT = "FIGHT"
	function THC_COUNTDOWN_STRING_OVERTIME(n)
		if n == 1 then return "OVERTIME"
		elseif n > 1 then return "OVERTIME x"..n end
	end

	THC_COUNTDOWN_FONT_FACE = THC_FONT_HUD
	THC_COUNTDOWN_FONT_COLOR = THC_COLOR.WHITE
	THC_COUNTDOWN_TEXT_DISPLAY_TIME = 1000
	THC_COUNTDOWN_TEXT_FADE_TIME = 1000
	THC_COUNTDOWN_SIZE_START = THC_FONT_SIZE_FUCK_OFF

	THC_COUNTDOWN_TEXT_TOTAL_TIME = THC_COUNTDOWN_TEXT_DISPLAY_TIME+THC_COUNTDOWN_TEXT_FADE_TIME
	THC_COUNTDOWN_SIZE_END = THC_COUNTDOWN_SIZE_START*2

	THC_AWARD = {}

	THC_AWARD.SCALE_SMALL = 10
	THC_AWARD.FONT_FACTOR_TEXT_SMALL = 4
	THC_AWARD.FONT_FACTOR_SUBTEXT_SMALL = 1.7

	THC_AWARD.SCALE_LARGE = 20
	THC_AWARD.FONT_FACTOR_TEXT_LARGE = 3
	THC_AWARD.FONT_FACTOR_SUBTEXT_LARGE = 1.3

	THC_AWARD.ICON_FACTOR_FRAG = function(n) if n and n>=0 and n<=8 then return 0.475 else return 0.7 end end
	THC_AWARD.ICON_FACTOR_AWARD = function() return 0.7 end

	THC_AWARD.ICON_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LIGHTER
	THC_AWARD.FONT_FACE = THC_FONT_HUD

	THC_AWARD.IMPRESSIVE = {}
	THC_AWARD.IMPRESSIVE.THRESHOLD = 2
	THC_AWARD.IMPRESSIVE.TIMEOUT = 10
	THC_AWARD.IMPRESSIVE.FADE_IN = 0.25
	THC_AWARD.IMPRESSIVE.DISPLAY_TIME = 2
	THC_AWARD.IMPRESSIVE.FADE_OUT = 0.25
	THC_AWARD.IMPRESSIVE.TEXT = "Impressive"
	THC_AWARD.IMPRESSIVE.SUBTEXT = function(n) if not n or n == 1 then return "YOU HIT A RAIL" else return tostring(n).." RAILS IN A ROW" end end
	THC_AWARD.IMPRESSIVE.SOUND = "internal/ui/thcHUD/weapon_hit_kill"
	THC_AWARD.IMPRESSIVE.ICON = "internal/ui/thcHUD/icon_impressive"
	THC_AWARD.IMPRESSIVE.THEME = function() return THC_AWARD.THEMES.SPECIAL end
	THC_AWARD.IMPRESSIVE.SCALE = THC_AWARD.SCALE_SMALL
	THC_AWARD.IMPRESSIVE.FONT_FACE = THC_AWARD.FONT_FACE
	THC_AWARD.IMPRESSIVE.FONT_COLOR = THC_AWARD.FONT_COLOR
	THC_AWARD.IMPRESSIVE.SHADOW_COLOR = THC_AWARD.SHADOW_COLOR
	THC_AWARD.IMPRESSIVE.FONT_FACTOR_TEXT = THC_AWARD.FONT_FACTOR_TEXT_SMALL
	THC_AWARD.IMPRESSIVE.FONT_FACTOR_SUBTEXT = THC_AWARD.FONT_FACTOR_SUBTEXT_SMALL
	THC_AWARD.IMPRESSIVE.ICON_FACTOR = THC_AWARD.ICON_FACTOR_AWARD
	doAwardScaling(THC_AWARD.IMPRESSIVE)

	THC_AWARD.EXCELLENT = {}
	THC_AWARD.EXCELLENT.THRESHOLD = 2
	THC_AWARD.EXCELLENT.TIMEOUT = 5
	THC_AWARD.EXCELLENT.FADE_IN = 0.25
	THC_AWARD.EXCELLENT.DISPLAY_TIME = 2
	THC_AWARD.EXCELLENT.FADE_OUT = 0.25
	THC_AWARD.EXCELLENT.TEXT = "Excellent"
	THC_AWARD.EXCELLENT.SUBTEXT = function(n) if not n or n == 1 then return "YOU KILLED SOMETHING" else return tostring(n).." FRAGS IN A ROW" end end
	THC_AWARD.EXCELLENT.SOUND = "internal/ui/thcHUD/weapon_hit_kill"
	THC_AWARD.EXCELLENT.ICON = "internal/ui/thcHUD/icon_skull"
	THC_AWARD.EXCELLENT.THEME = function(n) if not n or n == 1 then return THC_AWARD.THEMES.DEFAULT else return THC_AWARD.THEMES.SPECIAL end end
	THC_AWARD.EXCELLENT.SCALE = THC_AWARD.SCALE_SMALL
	THC_AWARD.EXCELLENT.FONT_FACE = THC_AWARD.FONT_FACE
	THC_AWARD.EXCELLENT.FONT_COLOR = THC_AWARD.FONT_COLOR
	THC_AWARD.EXCELLENT.SHADOW_COLOR = THC_AWARD.SHADOW_COLOR
	THC_AWARD.EXCELLENT.FONT_FACTOR_TEXT = THC_AWARD.FONT_FACTOR_TEXT_SMALL
	THC_AWARD.EXCELLENT.FONT_FACTOR_SUBTEXT = THC_AWARD.FONT_FACTOR_SUBTEXT_SMALL
	THC_AWARD.EXCELLENT.ICON_FACTOR = THC_AWARD.ICON_FACTOR_AWARD
	doAwardScaling(THC_AWARD.EXCELLENT)

	killIconThemes = {}

	THC_AWARD.KILL = {}
	THC_AWARD.KILL.THRESHOLD = 1
	THC_AWARD.KILL.FADE_IN = 0.25
	THC_AWARD.KILL.DISPLAY_TIME = 3
	THC_AWARD.KILL.FADE_OUT = 0.25
	THC_AWARD.KILL.THEME = function(n) return killIconThemes[n or -1] or THC_AWARD.THEMES.WEAPON end
	THC_AWARD.KILL.SCALE = 10
	THC_AWARD.KILL.FONT_FACE = THC_AWARD.FONT_FACE
	THC_AWARD.KILL.FONT_FACTOR_TEXT = THC_AWARD.FONT_FACTOR_TEXT_SMALL
	THC_AWARD.KILL.FONT_FACTOR_SUBTEXT = THC_AWARD.FONT_FACTOR_TEXT_SMALL
	THC_AWARD.KILL.ICON_FACTOR = THC_AWARD.ICON_FACTOR_FRAG
	THC_AWARD.KILL.SUICIDE_THEME = function(n) return killIconThemes[n or -1] or THC_AWARD.THEMES.SUICIDE end
	THC_AWARD.KILL.COUNTER_X_ALIGN = -1
	THC_AWARD.KILL.COUNTER_Y_ALIGN = -1
	doFragMessageScaling(THC_AWARD.KILL)

	THC_AWARD.SUICIDE = {}
	THC_AWARD.SUICIDE.THRESHOLD = THC_AWARD.KILL.THRESHOLD
	THC_AWARD.SUICIDE.FADE_IN = THC_AWARD.KILL.FADE_IN
	THC_AWARD.SUICIDE.DISPLAY_TIME = THC_AWARD.KILL.DISPLAY_TIME
	THC_AWARD.SUICIDE.FADE_OUT = THC_AWARD.KILL.FADE_OUT
	THC_AWARD.SUICIDE.THEME = function(n) return killIconThemes[n or -1] or THC_AWARD.THEMES.SUICIDE end
	THC_AWARD.SUICIDE.SCALE = THC_AWARD.KILL.SCALE
	THC_AWARD.SUICIDE.FONT_FACE = THC_AWARD.KILL.FONT_FACE
	THC_AWARD.SUICIDE.FONT_FACTOR_TEXT = THC_AWARD.KILL.FONT_FACTOR_TEXT
	THC_AWARD.SUICIDE.FONT_FACTOR_SUBTEXT = THC_AWARD.KILL.FONT_FACTOR_SUBTEXT
	THC_AWARD.SUICIDE.ICON_FACTOR = THC_AWARD.KILL.ICON_FACTOR
	THC_AWARD.SUICIDE.COUNTER_X_ALIGN = 1
	THC_AWARD.SUICIDE.COUNTER_Y_ALIGN = 1
	doFragMessageScaling(THC_AWARD.SUICIDE)

	THC_AWARD.DEAD = {}
	THC_AWARD.DEAD.THRESHOLD = 1
	THC_AWARD.DEAD.TEXT = "Dead"
	--THC_AWARD.DEAD.SUBTEXT = function(n) if n == 1 then return "YOU ARE DEAD" else return n.." DEATHS IN A ROW" end end
	--THC_AWARD.DEAD.SOUND = "internal/ui/thcHUD/weapon_hit_kill"
	THC_AWARD.DEAD.ICON = "internal/ui/thcHUD/icon_skull"
	THC_AWARD.DEAD.THEME = function() return THC_AWARD.THEMES.BAD end
	THC_AWARD.DEAD.SCALE = THC_AWARD.SCALE_LARGE
	THC_AWARD.DEAD.FONT_FACE = THC_AWARD.FONT_FACE
	THC_AWARD.DEAD.FONT_COLOR = THC_AWARD.FONT_COLOR
	THC_AWARD.DEAD.SHADOW_COLOR = THC_AWARD.SHADOW_COLOR
	THC_AWARD.DEAD.FONT_FACTOR_TEXT = THC_AWARD.FONT_FACTOR_TEXT_LARGE
	THC_AWARD.DEAD.FONT_FACTOR_SUBTEXT = THC_AWARD.FONT_FACTOR_SUBTEXT_LARGE
	THC_AWARD.DEAD.ICON_FACTOR = THC_AWARD.ICON_FACTOR_AWARD
	doAwardScaling(THC_AWARD.DEAD)

	THC_AWARD.THEMES =
	{
		DEFAULT =
		{
			FOREGROUND_COLOR = THC_COLOR.WHITE;
			BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.LIGHTER;
			BORDER_COLOR = THC_COLOR.TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		SPECIAL =
		{
			FOREGROUND_COLOR = THC_COLOR.WHITE;
			BACKGROUND_COLOR = THC_COLOR.BLACK;
			BORDER_COLOR = THC_COLOR.ORANGE;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		BAD =
		{
			FOREGROUND_COLOR = THC_COLOR.ORANGE;
			BACKGROUND_COLOR = THC_COLOR.GREY.DARK;
			BORDER_COLOR = THC_COLOR.ORANGE;
			FULLSCREEN_BACKGROUND = THC_COLOR.LESS_TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		WEAPON =
		{
			FOREGROUND_COLOR = THC_COLOR.WHITE;
			BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.NORMAL;
			BORDER_COLOR = THC_COLOR.TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		NOT_WEAPON =
		{
			FOREGROUND_COLOR = THC_COLOR.GREY.DARK;
			BACKGROUND_COLOR = THC_COLOR.ORANGE;
			BORDER_COLOR = THC_COLOR.TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		SUICIDE =
		{
			FOREGROUND_COLOR = THC_COLOR.WHITE;
			BACKGROUND_COLOR = THC_COLOR.ACTUALLY_RED;
			BORDER_COLOR = THC_COLOR.TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
		FIRE =
		{
			FOREGROUND_COLOR = THC_COLOR.FIRE.RED;
			BACKGROUND_COLOR = THC_COLOR.FIRE.ORANGE;
			BORDER_COLOR = THC_COLOR.TRANSPARENT_BLACK;
			TEXT_COLOR = THC_COLOR.WHITE;
			SUBTEXT_COLOR = THC_COLOR.WHITE;
			TEXT_SHADOW_COLOR = THC_COLOR.BLACK;
			SUBTEXT_SHADOW_COLOR = THC_COLOR.BLACK;
		};
	}
	killIconThemes[DAMAGE_TYPE_MELEE] = THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_LAVA] = THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_DROWN] =  THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_OUTOFWORLD] = THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_TELEFRAG] = THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_OVERTIME] = THC_AWARD.THEMES.NOT_WEAPON
	killIconThemes[DAMAGE_TYPE_SUICIDE] = THC_AWARD.THEMES.SUICIDE


	THC_WEAPONSLOT_COUNT = 8
	THC_WEAPONSLOT_WIDTH = 84
	THC_WEAPONSLOT_HEIGHT = 30
	THC_WEAPONSLOT_BORDER = THC_BORDER_THIN
	THC_WEAPONSLOT_BORDER_COLOR = THC_COLOR.BLACK(255)
	THC_WEAPONSLOT_DEFAULT_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARK(255)
	THC_WEAPONSLOT_DISABLED_BACKGROUND_COLOR = THC_COLOR.FOREST_GREEN.DARKEST(255)
	THC_WEAPONSLOT_SELECTED_BACKGROUND_COLOR = THC_COLOR.MINT(255)
	THC_WEAPONSLOT_DEFAULT_FOREGROUND_COLOR = THC_COLOR.WHITE(255)
	THC_WEAPONSLOT_DISABLED_FOREGROUND_COLOR = THC_COLOR.GREY.NORMAL(255)
	THC_WEAPONSLOT_SELECTED_FOREGROUND_COLOR = THC_COLOR.BLACK(255)
	THC_WEAPONSLOT_FONT_FACE = THC_FONT_HUD

	THC_WEAPONSLOT_CALC_WIDTH = THC_WEAPONSLOT_WIDTH+THC_WEAPONSLOT_BORDER
	THC_WEAPONSLOT_CALC_HEIGHT = THC_WEAPONSLOT_HEIGHT+THC_WEAPONSLOT_BORDER
	THC_WEAPONSLOT_TRUE_WIDTH = THC_WEAPONSLOT_WIDTH+THC_WEAPONSLOT_BORDER*2
	THC_WEAPONSLOT_TRUE_HEIGHT = THC_WEAPONSLOT_HEIGHT+THC_WEAPONSLOT_BORDER*2
	THC_WEAPONSLOT_X = THC_WEAPONSLOT_BORDER*0.5
	THC_WEAPONSLOT_Y = THC_WEAPONSLOT_BORDER*0.5
	THC_WEAPONSLOT_ICON_RADIUS = THC_WEAPONSLOT_HEIGHT*0.4
	THC_WEAPONSLOT_ICON_X = roundHalfUp(THC_WEAPONSLOT_BORDER+THC_WEAPONSLOT_WIDTH*0.1+THC_WEAPONSLOT_ICON_RADIUS)
	THC_WEAPONSLOT_TEXT_X = roundHalfUp(THC_WEAPONSLOT_ICON_X+THC_WEAPONSLOT_WIDTH*0.3+THC_WEAPONSLOT_ICON_RADIUS)
	THC_WEAPONSLOT_CONTENT_Y = roundHalfUp(THC_WEAPONSLOT_TRUE_HEIGHT/2)
	THC_WEAPONSLOT_FONT_SIZE = roundHalfUp(THC_WEAPONSLOT_HEIGHT*0.75);
	THC_WEAPONRACK_WIDTH = THC_WEAPONSLOT_COUNT*THC_WEAPONSLOT_TRUE_WIDTH+(THC_WEAPONSLOT_COUNT-1)*THC_DEFAULT_SPACING
	THC_WEAPONRACK_LEFT = -math.floor(THC_WEAPONRACK_WIDTH/2)


	THC_WEAPON_AXE = 1
	THC_WEAPON_BURST = 2
	THC_WEAPON_SHOTGUN = 3
	THC_WEAPON_GRENADE = 4
	THC_WEAPON_PLASMA = 5
	THC_WEAPON_ROCKET = 6
	THC_WEAPON_LIGHTNING = 7
	THC_WEAPON_RAIL = 8
	THC_WEAPON_STAKE = 9

	thc_weaponSvg = {}
	for i=1,9 do thc_weaponSvg[i] = "internal/ui/icons/weapon"..i end

	thc_damageSvg = {}
	thc_damageSvg[DAMAGE_TYPE_MELEE] = "internal/ui/icons/weapon1"
	thc_damageSvg[DAMAGE_TYPE_BURST] = "internal/ui/icons/weapon2"
	thc_damageSvg[DAMAGE_TYPE_SHELL] = "internal/ui/icons/weapon3"
	thc_damageSvg[DAMAGE_TYPE_GRENADE] = "internal/ui/icons/weapon4"
	thc_damageSvg[DAMAGE_TYPE_PLASMA] = "internal/ui/icons/weapon5"
	thc_damageSvg[DAMAGE_TYPE_ROCKET] = "internal/ui/icons/weapon6"
	thc_damageSvg[DAMAGE_TYPE_BEAM] = "internal/ui/icons/weapon7"
	thc_damageSvg[DAMAGE_TYPE_BOLT] = "internal/ui/icons/weapon8"
	thc_damageSvg[DAMAGE_TYPE_STAKE] = "internal/ui/icons/weapon9"
	thc_damageSvg[DAMAGE_TYPE_LAVA] = "internal/ui/thcHUD/icon_lava"
	thc_damageSvg[DAMAGE_TYPE_DROWN] = "internal/ui/thcHUD/icon_skull"
	thc_damageSvg[DAMAGE_TYPE_OUTOFWORLD] = "internal/ui/thcHUD/icon_skull"
	thc_damageSvg[DAMAGE_TYPE_TELEFRAG] = "internal/ui/thcHUD/icon_telefrag"
	thc_damageSvg[DAMAGE_TYPE_OVERTIME] = "internal/ui/thcHUD/icon_clock"
	thc_damageSvg[DAMAGE_TYPE_SUICIDE] = "internal/ui/thcHUD/icon_skull"

	thc_suicideString = {}
	-- Many of these can't ever be shown so are just me mucking around
	thc_suicideString[DAMAGE_TYPE_MELEE] = "%s blugeoned themselves to death"
	thc_suicideString[DAMAGE_TYPE_BURST] = "%s should have installed Qualx's widget"
	thc_suicideString[DAMAGE_TYPE_SHELL] = "%s was holding the shotgun the wrong way round"
	thc_suicideString[DAMAGE_TYPE_GRENADE] = "%s does not understand grenades"
	thc_suicideString[DAMAGE_TYPE_PLASMA] = "%s something something plasma rifle"
	thc_suicideString[DAMAGE_TYPE_ROCKET] = "%s blew themselves up"
	thc_suicideString[DAMAGE_TYPE_BEAM] = "%s deserved it"
	thc_suicideString[DAMAGE_TYPE_BOLT] = "%s really deserved it"
	thc_suicideString[DAMAGE_TYPE_STAKE] = "%s ate too much steak"
	thc_suicideString[DAMAGE_TYPE_LAVA] = "%s melted in lava"
	thc_suicideString[DAMAGE_TYPE_DROWN] = "%s somehow managed to drown"
	thc_suicideString[DAMAGE_TYPE_OUTOFWORLD] = "%s appreciates tehace's mapping skills"
	thc_suicideString[DAMAGE_TYPE_TELEFRAG] = "%s was in the wrong place at the wrong time"
	thc_suicideString[DAMAGE_TYPE_OVERTIME] = "%s is playing the wrong gamemode"
	thc_suicideString[DAMAGE_TYPE_SUICIDE] = "%s committed suicide"

end

function thc_shouldTickGameHud()
	if clientGameState == STATE_CONNECTED and not (replayName == "menu")
	then local player = getLocalPlayer()
		if player
		and player.connected
		then return true end end
	return false
end

function thc_shouldDrawGameHud(evenWhenGameOver)
	if thc_shouldTickGameHud()
		and (evenWhenGameOver or world.gameState ~= GAME_STATE_GAMEOVER)
		and not isInMenu()
		and (consoleGetVariable("ui_thc_force_show") == 1 or consoleGetVariable("cl_show_hud") == 1)
	then return true end
	return false
end

function thc_shouldDrawPlayerHud(evenWhenGameOver)
	if thc_shouldDrawGameHud(evenWhenGameOver)
	then local player = getPlayer()
		if player
		and player.connected
		and player.state == PLAYER_STATE_INGAME
		then return true end end
	return false
end

function thc_shouldDrawSpecHud(evenWhenGameOver)
	if thc_shouldDrawGameHud(evenWhenGameOver)
		and (players[playerIndexLocalPlayer].state == PLAYER_STATE_SPECTATOR or players[playerIndexLocalPlayer].state == PLAYER_STATE_QUEUED)
	then return true end 
	return false
end

function thc_lerpColor(color1,color2,k,forceAlpha)
	local color = {};
	color.r = lerp(color1.r, color2.r, k);
	color.g = lerp(color1.g, color2.g, k);
	color.b = lerp(color1.b, color2.b, k);
	color.a = forceAlpha or lerp(color1.a, color2.a, k);
	return color;
end

function thc_drawMeter(alignH,alignV,value,maxValue,color1,color2,label,settings)
	if alignH == NVG_ALIGN_CENTER or alignV == NVG_ALIGN_BASELINE or alignV == NVG_ALIGN_MIDDLE then consolePrint("PLEASE DO NOT CENTER ALIGN") return end
	nvgSave()
	nvgTranslate(settings.TRUE_X*(alignH-NVG_ALIGN_CENTER),settings.TRUE_Y*(alignV-NVG_ALIGN_MIDDLE))
	nvgSave()
	if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
	if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
	nvgBeginPath()
	nvgRect(
		settings.X,
		settings.Y,
		settings.CALC_WIDTH,
		settings.CALC_HEIGHT
	)
	nvgFillColor(value > maxValue and color1 or settings.BACKGROUND_COLOR)
	nvgFill()
	if value > 0 then
		local modValue = value%maxValue
		if modValue == 0 then modValue = maxValue end
		nvgScissor(0,0,roundHalfUp(settings.WIDTH*modValue/maxValue)+settings.BORDER,settings.TRUE_HEIGHT)
		nvgFillColor(value > maxValue and color2 or color1 or settings.BACKGROUND_COLOR)
		nvgFill()
		nvgResetScissor()
	end
	if settings.BORDER > 0 then
		nvgStrokeColor(settings.BORDER_COLOR)
		nvgStrokeWidth(settings.BORDER)
		nvgStroke()
	end
	
	nvgRestore()
	nvgBeginPath()
	nvgFontBlur(0)
	nvgFontSize(settings.FONT_SIZE)
	nvgFontFace(settings.FONT_FACE)
	nvgTextAlign(settings.TEXT_ALIGN or (NVG_ALIGN_RIGHT-alignH), NVG_ALIGN_MIDDLE)
	nvgFillColor(settings.FONT_COLOR)
	nvgText((alignH-NVG_ALIGN_CENTER)*settings.CALC_VALUE_MARGIN,(alignV-NVG_ALIGN_MIDDLE)*settings.TRUE_HEIGHT/2,label or math.max(value,0))
	nvgRestore()
end

function thc_drawDoubleMeter(alignH,alignV,value1,value2,maxValue,color1,color2,label,settings)
	if alignH == NVG_ALIGN_CENTER or alignV == NVG_ALIGN_BASELINE or alignV == NVG_ALIGN_MIDDLE then consolePrint("PLEASE DO NOT CENTER ALIGN") return end
	nvgSave()
	nvgTranslate(settings.TRUE_X*(alignH-NVG_ALIGN_CENTER),settings.TRUE_Y*(alignV-NVG_ALIGN_MIDDLE))
	nvgSave()
	if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
	if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
	nvgBeginPath()
	nvgRect(
		settings.X,
		settings.Y,
		settings.CALC_WIDTH,
		settings.CALC_HEIGHT
	)
	nvgFillColor(settings.BACKGROUND_COLOR)
	nvgFill()
	if value1 > 0 then
		nvgScissor(0,0,roundHalfUp(settings.WIDTH*math.min(value1/maxValue,1))+settings.BORDER,settings.TRUE_HEIGHT)
		nvgFillColor(color1)
		nvgFill()
		nvgResetScissor()
		if value2 > 0 then
			nvgScissor(0,0,roundHalfUp(settings.WIDTH*math.min(math.min(value1,value2)/maxValue,1))+settings.BORDER,settings.TRUE_HEIGHT)
			nvgFillColor(color2)
			nvgFill()
			nvgResetScissor()
		end
	end
	if settings.BORDER > 0 then
		nvgStrokeColor(settings.BORDER_COLOR)
		nvgStrokeWidth(settings.BORDER)
		nvgStroke()
	end
	
	nvgRestore()
	nvgBeginPath()
	nvgFontBlur(0)
	nvgFontSize(settings.FONT_SIZE)
	nvgFontFace(settings.FONT_FACE)
	nvgTextAlign((NVG_ALIGN_RIGHT-alignH), NVG_ALIGN_MIDDLE)
	nvgFillColor(settings.FONT_COLOR)
	if label and label ~= "" then nvgText((alignH-NVG_ALIGN_CENTER)*settings.CALC_VALUE_MARGIN,(alignV-NVG_ALIGN_MIDDLE)*settings.TRUE_HEIGHT/2,label) end
	nvgRestore()
end

function thc_drawMultiMeter(x,y,alignH,alignV,label,settingsArray,meterWidth,meterHeight,borderThickness,fontScale,labelMargin,bgColor,borderColor,fontColor)	-- settingsArray contains tables requiring fields value,maxValue,color
	if alignH == NVG_ALIGN_CENTER or alignV == NVG_ALIGN_BASELINE or alignV == NVG_ALIGN_MIDDLE then consolePrint("PLEASE DO NOT CENTER ALIGN") return end
	nvgSave()
	nvgTranslate(x,y)
	nvgSave()
	if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
	if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
	local meterX = borderThickness*0.5
	local meterY = borderThickness*0.5
	local meterCalcLabelMargin = borderThickness+labelMargin
	local meterCalcLabelMarginMidpoint = borderThickness+labelMargin/2
	local meterTrueHeight = meterHeight + borderThickness*2
	local fontSize = meterHeight*fontScale
	nvgBeginPath()
	nvgRect(
		meterX,
		meterY,
		meterWidth + borderThickness,
		meterHeight + borderThickness
	)
	nvgFillColor(bgColor)
	nvgFill()
	local maxTotal = 0
	local valueTotal = 0
	for i=#settingsArray,1,-1 do
		maxTotal = maxTotal + settingsArray[i].maxValue
		valueTotal = valueTotal + math.min(math.max(settingsArray[i].value,0),settingsArray[i].maxValue)
	end
	for i=#settingsArray,1,-1 do
		local value = math.min(math.max(settingsArray[i].value,0),settingsArray[i].maxValue)
		local color = settingsArray[i].color
		if value > 0 then
			nvgScissor(meterX,meterY,(meterWidth*(valueTotal/maxTotal))+borderThickness,meterTrueHeight)
			nvgFillColor(color)
			nvgFill()
			nvgResetScissor()
			valueTotal = valueTotal - value
		end
	end
	nvgStrokeColor(borderColor)
	nvgStrokeWidth(borderThickness)
	nvgStroke()
	nvgRestore()
	nvgBeginPath()
	nvgFontBlur(0)
	nvgFontSize(fontSize)
	nvgFontFace(THC_METER.FONT_FACE)
	nvgTextAlign((NVG_ALIGN_RIGHT-alignH), NVG_ALIGN_MIDDLE)
	nvgFillColor(fontColor)
	nvgText((alignH-NVG_ALIGN_CENTER)*(borderThickness+labelMargin),(alignV-NVG_ALIGN_MIDDLE)*meterTrueHeight/2,label or math.max(value,0))
	nvgRestore()
end

function thc_drawTimer(alignH,alignV,timeRemaining,timeMax,iconFactory,iconColorFactory,iconParameter)
	if alignH == NVG_ALIGN_CENTER or alignV == NVG_ALIGN_BASELINE or alignV == NVG_ALIGN_MIDDLE then consolePrint("PLEASE DO NOT CENTER ALIGN") return end
	nvgSave()
	if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
	if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
	nvgBeginPath()
	nvgRect(
		THC_TIMER_X,
		THC_TIMER_Y,
		THC_TIMER_CALC_WIDTH,
		THC_TIMER_CALC_HEIGHT
	)
	nvgFillColor(THC_TIMER_BACKGROUND_COLOR)
	nvgFill()
	nvgStrokeColor(THC_TIMER_BORDER_COLOR)
	nvgStrokeWidth(THC_TIMER_BORDER)
	nvgStroke()
	
	nvgBeginPath()
	if timeRemaining and timeRemaining ~= 0 then
		nvgTranslate(THC_TIMER_MIDPOINT_X,THC_TIMER_MIDPOINT_Y)
		if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
		if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
		nvgBeginPath()
		nvgFillColor(iconColorFactory(255))
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
		nvgFontSize(THC_TIMER_FONT_SIZE)
		nvgFontFace(THC_TIMER_FONT_FACE)
		nvgFontBlur(0)
		nvgText(0,0,timeRemaining or "HELD")
	else
		nvgTranslate(THC_TIMER_MIDPOINT_X,THC_TIMER_MIDPOINT_Y)
		if alignH < NVG_ALIGN_CENTER then nvgScale(-1,1) end
		if alignV < NVG_ALIGN_MIDDLE then nvgScale(1,-1) end
		if iconParameter then iconFactory(THC_ICON_LARGE_RADIUS,iconColorFactory(255),iconParameter)
		else iconFactory(THC_ICON_LARGE_RADIUS,iconColorFactory(255)) end
	end
	nvgRestore()
end

function thc_drawWeaponSlot(weaponIndex,ammo,iconColor)
	nvgSave()
	nvgBeginPath()
	nvgRect(
		THC_WEAPONSLOT_X,
		THC_WEAPONSLOT_Y,
		THC_WEAPONSLOT_CALC_WIDTH,
		THC_WEAPONSLOT_CALC_HEIGHT
	)
	nvgStrokeWidth(THC_WEAPONSLOT_BORDER)
	nvgStrokeColor(THC_WEAPONSLOT_BORDER_COLOR)
	local localPlayer = getLocalPlayer()
	local isInGame = (localPlayer and localPlayer.state == PLAYER_STATE_INGAME and replayName == "")
	local lightColor = {r = (127.5+iconColor.r)/1.5; g = (127.5+iconColor.g)/1.5; b = (127.5+iconColor.b)/1.5; a = 255;}
	local darkColor = {r = iconColor.r/2; g = iconColor.g/2; b = iconColor.b/2; a = 255;}
	if getPlayer().weaponIndexSelected == weaponIndex then
		local intensity = getPlayer().weaponSelectionIntensity
		nvgFillColor(thc_lerpColor(THC_WEAPONSLOT_DEFAULT_BACKGROUND_COLOR,THC_WEAPONSLOT_SELECTED_BACKGROUND_COLOR,intensity,255))
		nvgFill()
		nvgStroke()
		nvgFillColor(thc_lerpColor(THC_WEAPONSLOT_DEFAULT_FOREGROUND_COLOR,THC_WEAPONSLOT_SELECTED_FOREGROUND_COLOR,intensity,255))
		nvgSave()
		if consoleGetVariable("ui_thc_color_weapons") >= (isInGame and 1 or 2) then nvgFillColor(thc_lerpColor(lightColor,darkColor,intensity,255)) end
	elseif weaponIndex == 1 or ammo > 0 then
		nvgFillColor(THC_WEAPONSLOT_DEFAULT_BACKGROUND_COLOR)
		nvgFill()
		nvgStroke()
		nvgFillColor(THC_WEAPONSLOT_DEFAULT_FOREGROUND_COLOR)
		nvgSave()
		if consoleGetVariable("ui_thc_color_weapons") == (isInGame and 1 or 2) then nvgFillColor(lightColor) end
	else
		nvgFillColor(THC_WEAPONSLOT_DISABLED_BACKGROUND_COLOR)
		nvgFill()
		nvgStroke()
		nvgFillColor(THC_WEAPONSLOT_DISABLED_FOREGROUND_COLOR)
		nvgSave()
	end
	nvgSvg(thc_weaponSvg[weaponIndex],THC_WEAPONSLOT_ICON_X,THC_WEAPONSLOT_CONTENT_Y,THC_WEAPONSLOT_ICON_RADIUS)
	nvgRestore()
	nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
	nvgFontSize(THC_WEAPONSLOT_FONT_SIZE)
	nvgFontFace(THC_TIMER_FONT_FACE)
	nvgFontBlur(0)
	nvgText(THC_WEAPONSLOT_TEXT_X,THC_WEAPONSLOT_CONTENT_Y,weaponIndex ~= 1 and ammo or "-")
	nvgRestore()
end

function thc_drawAward(alpha,halfDividerWidth,icon,text,subtext,params,theme,number)
	nvgSave()
	if icon then
		nvgBeginPath()
		nvgFillColor(theme.BORDER_COLOR(alpha))
		thc_drawHexagonPath(params.ICON_BORDER_RADIUS)
		nvgFill()
		nvgBeginPath()
		nvgFillColor(theme.BACKGROUND_COLOR(alpha))
		thc_drawHexagonPath(params.ICON_RADIUS)
		nvgFill()
		nvgFillColor(theme.FOREGROUND_COLOR(alpha))
		nvgSvg(icon,0,0,params.ICON_RADIUS*params.ICON_FACTOR(number or -1))
	end

	nvgFontFace(params.FONT_FACE);
	if text then
		nvgTextAlign(params.TEXT_ALIGN_H, params.TEXT_ALIGN_V);
		nvgFontSize(params.FONT_SIZE_TEXT);
		nvgFontBlur(2);
		nvgFillColor(theme.TEXT_SHADOW_COLOR(alpha));
		nvgText(params.TEXT_X,params.TEXT_Y+1,text);
		nvgFontBlur(0);
		nvgFillColor(theme.TEXT_COLOR(alpha));
		nvgText(params.TEXT_X,params.TEXT_Y,text);
	end

	if text and subtext and params.DIVIDER then
		nvgBeginPath()
		nvgStrokeColor(params.DIVIDER_COLOR(alpha))
		nvgMoveTo(params.DIVIDER_X-(halfDividerWidth or 0),params.DIVIDER_Y)
		nvgLineTo(params.DIVIDER_X+(halfDividerWidth or 0),params.DIVIDER_Y)
		nvgStroke()
	end

	if subtext then
		nvgTextAlign(params.SUBTEXT_ALIGN_H, params.SUBTEXT_ALIGN_V);
		nvgFontSize(params.FONT_SIZE_SUBTEXT);
		nvgFontBlur(2);
		nvgFillColor(theme.SUBTEXT_SHADOW_COLOR(alpha));
		nvgText(params.SUBTEXT_X,params.SUBTEXT_Y+1,subtext);
		nvgFontBlur(0);
		nvgFillColor(theme.SUBTEXT_COLOR(alpha));
		nvgText(params.SUBTEXT_X,params.SUBTEXT_Y,subtext);
	end

	nvgTranslate(params.COUNTER_X,params.COUNTER_Y)
	if not params.FRAG_MESSAGE then
		if number and number > 1 then
			nvgBeginPath()
			nvgFillColor(theme.BORDER_COLOR(alpha))
			thc_drawHexagonPath(params.COUNTER_BORDER_RADIUS)
			nvgFill()
			nvgBeginPath()
			nvgFillColor(theme.BACKGROUND_COLOR(alpha))
			thc_drawHexagonPath(params.COUNTER_RADIUS)
			nvgFill()
			nvgFontSize(params.FONT_SIZE_COUNTER)
			nvgFontBlur(0)
			nvgFillColor(theme.FOREGROUND_COLOR(alpha))
			nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE);
			nvgText(0,0,number)
		end
	else
		if text and text ~= "" then
			nvgBeginPath()
			nvgFillColor(theme.BORDER_COLOR(alpha))
			thc_drawHexagonPath(params.COUNTER_BORDER_RADIUS)
			nvgFill()
			nvgBeginPath()
			nvgFillColor((params.PLUS_ONE_BACKGROUND_COLOR or theme.BACKGROUND_COLOR)(alpha))
			thc_drawHexagonPath(params.COUNTER_RADIUS)
			nvgFill()
			nvgFontSize(params.FONT_SIZE_COUNTER)
			nvgFontBlur(0)
			nvgFillColor((params.PLUS_ONE_TEXT_COLOR or theme.FOREGROUND_COLOR)(alpha))
			nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE);
			nvgText(0,0,"+1")
		else
			nvgBeginPath()
			nvgFillColor(theme.BORDER_COLOR(alpha))
			thc_drawHexagonPath(params.COUNTER_BORDER_RADIUS)
			nvgFill()
			nvgBeginPath()
			nvgFillColor((params.MINUS_ONE_BACKGROUND_COLOR or theme.BACKGROUND_COLOR)(alpha))
			thc_drawHexagonPath(params.COUNTER_RADIUS)
			nvgFill()
			nvgFontSize(params.FONT_SIZE_COUNTER)
			nvgFontBlur(0)
			nvgFillColor((params.MINUS_ONE_TEXT_COLOR or theme.FOREGROUND_COLOR)(alpha))
			nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE);
			nvgText(0,0,"-1")
		end
	end
	nvgRestore()
end

function thc_getCounterFunction(interval,roundingThreshold,factor,updateFunction,drawFunction,isIncremental)
	-- negative interval means counter will count down
	-- set roundingThreshold to 0 means round everything up (unless perfect), set it to interval means round everything down. If exactly threshold, it rounds up.
	-- updateFunction will be called with value if different, drawFunction will always be called with only the first return value of updateFunction, and the offset value. Use table if multiple args.

	local drawArgument = nil
	local lastValue = nil
	local exactValue = nil

	return function(currentValue)
		if not currentValue then drawArgument = nil lastValue = nil exactValue = 0 return end
		local residue
		if isIncremental then
			exactValue = currentValue + (exactValue or 0)
		else
			exactValue = currentValue
		end
		residue = exactValue % interval
		local rounded
		if residue < roundingThreshold then
			residue = -residue
		elseif residue ~= 0 then
			residue = interval - residue
		end
		rounded = exactValue + residue
		if rounded ~= lastValue then drawArgument = updateFunction(rounded*factor) lastValue = rounded end
		if drawArgument then return drawFunction(drawArgument,residue/interval) else lastValue = nil exactValue = nil end
	end
end

-- Hack to get convars called whatever I want (prefaced with ui_thc_ of course)
if not THC_CORE_INCLUDED then
	defineLiterallyEverything(2)
	THC = {canHide = false; canPosition = false;}
	registerWidget("THC")
	function THC:initialize()
		widgetCreateConsoleVariable("force_show","int",0)			-- should show HUD even if cl_show_hud is set to 0 (this is for replay things)
		widgetCreateConsoleVariable("scoreboard_ping_delay","float",1.0)	-- time in seconds before ping starts to slide out with +showScores
		widgetCreateConsoleVariable("scoreboard_ping_transition","float",0.2)	-- time in seconds for ping to slide out
		widgetCreateConsoleVariable("speedmeter","int",1)			-- whether we should show speedmeter
		widgetCreateConsoleVariable("speedmeter_max","float",0.0)		-- 0 means it'll use the weird variable scale thing I made
		widgetCreateConsoleVariable("spacing","int",2)				-- default spacing between adjacent panels in pixels
		widgetCreateConsoleVariable("deathscreen_show","int",2)			-- draw the death screen 0/1/2
		widgetCreateConsoleVariable("killfeed_show","int",2)			-- draw the killfeed 0/1/2
		widgetCreateConsoleVariable("killfeed_maxcount","int",8)		-- max killfeed messages to display
		widgetCreateConsoleVariable("killfeed_spec_x","int",0)			-- x coordinate for midline of killfeed (spec)
		widgetCreateConsoleVariable("killfeed_spec_y","int",-160)		-- y coordinate for midline of first killfeed item (spec)
		widgetCreateConsoleVariable("killfeed_spec_scale","float",1)		-- scale factor for killfeed (spec)
		widgetCreateConsoleVariable("killfeed_ingame_x","int",-680)		-- x coordinate for midline of killfeed (ingame)
		widgetCreateConsoleVariable("killfeed_ingame_y","int",-225)		-- y coordinate for midline of first killfeed item (ingame)
		widgetCreateConsoleVariable("killfeed_ingame_scale","float",0.8)	-- scale factor for killfeed (ingame)
		widgetCreateConsoleVariable("award_y","int",-225)			-- y coordinate for midline of impressive/excellent awards
		widgetCreateConsoleVariable("award_excellent","int",2)			-- draw excellent awards 0/1/2
		widgetCreateConsoleVariable("award_impressive","int",1)			-- draw impressive awards 0/1
		widgetCreateConsoleVariable("scoreboard_force_ingame","int",0)		-- force scoreboard to draw even if you are ingame (this is a hacky workaround until I make a cut down version of the scoreboard for in-game players)
		widgetCreateConsoleVariable("pickuptimers","int",2)			-- when to draw pickup timers: 0 = never, 1 = in spec, 2 = always
		widgetCreateConsoleVariable("pickuptimers_mega","int",2)		-- when to display megahealth pickup timers: 0 = never, 1 = in spec, 2 = always
		widgetCreateConsoleVariable("pickuptimers_50hp","int",1)		-- when to display 50HP pickup timers: 0 = never, 1 = in spec (50HP timer is not exposed when ingame)
		widgetCreateConsoleVariable("pickuptimers_red","int",2)			-- when to display red armour pickup timers: 0 = never, 1 = in spec, 2 = always
		widgetCreateConsoleVariable("pickuptimers_yellow","int",2)		-- when to display yellow armour pickup timers: 0 = never, 1 = in spec, 2 = always
		widgetCreateConsoleVariable("pickuptimers_green","int",2)		-- when to display green armour pickup timers: 0 = never, 1 = in spec, 2 = always
		widgetCreateConsoleVariable("clock_ingame","int",2)			-- how to display clock ingame (spec will always behave as if set to 2): -1 = count up, 0 = CPM-style :XX, 1 = count down, 2 = count down plus hexagon
		widgetCreateConsoleVariable("clock_low_seconds","int",30)		-- time remaining when low time behaviour should start
		widgetCreateConsoleVariable("color_weapons","int",0)			-- should weapon icons be tinted for visibility: 0 = never, 1 = ingame, 2 = always
	end
	function THC:draw()
		local spacing = widgetGetConsoleVariable("spacing")
		local killfeedMax = widgetGetConsoleVariable("killfeed_maxcount")
		if THC_DEFAULT_SPACING ~= spacing then
			defineLiterallyEverything(spacing)
		end
		if killfeedMax and killfeedMax >= 1 then
			THC_AWARD.KILL.FEED_MAX = killfeedMax
		end
	end
	THC_CORE_INCLUDED = true
end
