require "base/internal/ui/reflexcore"

local function anglePaint(paintFunction,r,angleStart,angleSweep)
	r = math.ceil(r)
	local sweep = angleSweep
	local step
	if sweep == 0 then return end
	nvgSave()
	if sweep < 0 then
		-- this is technically bugged but meh
		sweep = -sweep
		angleStart = -angleStart
	else
	end
	if sweep >= 2*math.pi then nvgScissor(-r,-r,2*r,2*r)paintFunction()nvgResetScissor()nvgRestore()return end
	
	nvgRotate(angleStart)

	while sweep > 0.5*math.pi do
		nvgScissor(0,0,r,r)
		paintFunction()
		nvgResetScissor()
		sweep = sweep - 0.5*math.pi
		nvgRotate(0.5*math.pi)
	end
	if sweep > 0 then
		nvgSkewX(0.5*math.pi - sweep)
		nvgScissor(0,0,r,r)
		nvgSkewX(sweep - 0.5*math.pi)
		paintFunction()
	end
	nvgRestore()
end

function thc_angleStroke(r,angleStart,angleSweep) return anglePaint(nvgStroke,r,angleStart,angleSweep) end
function thc_angleFill(r,angleStart,angleSweep) return anglePaint(nvgFill,r,angleStart,angleSweep) end
function thc_angleStrokeFill(r,angleStart,angleSweep) return anglePaint(function()nvgStroke()nvgFill()end,r,angleStart,angleSweep) end
function thc_angleFillStroke(r,angleStart,angleSweep) return anglePaint(function()nvgFill()nvgStroke()end,r,angleStart,angleSweep) end

function thc_drawHexagonPath(r)
	nvgSave()
	nvgScale(1/12,1/12)
	local rBy1 = roundHalfDown(r*12)
	local rBy2 = roundHalfUp(r*6)
	local rTimesRoot3By2 = roundHalfUp(r*6*math.sqrt(3))
	nvgMoveTo(0,rBy1)
	nvgLineTo(rTimesRoot3By2,rBy2)
	nvgLineTo(rTimesRoot3By2,-rBy2)
	nvgLineTo(0,-rBy1)
	nvgLineTo(-rTimesRoot3By2,-rBy2)
	nvgLineTo(-rTimesRoot3By2,rBy2)
	nvgLineTo(0,rBy1)
	nvgRestore()
end

function thc_drawDonutHexagonPath(rOuter,rInner)
	nvgSave()
	nvgScale(1/12,1/12)
	local rOuterBy1 = roundHalfDown(rOuter*12)
	local rOuterBy2 = roundHalfUp(rOuter*6)
	local rOuterTimesRoot3By2 = roundHalfUp(rOuter*6*math.sqrt(3))
	local rInnerBy1 = roundHalfDown(rInner*12)
	local rInnerBy2 = roundHalfUp(rInner*6)
	local rInnerTimesRoot3By2 = roundHalfUp(rInner*6*math.sqrt(3))
	nvgMoveTo(0,rOuterBy1)
	nvgLineTo(rOuterTimesRoot3By2,rOuterBy2)
	nvgLineTo(rOuterTimesRoot3By2,-rOuterBy2)
	nvgLineTo(0,-rOuterBy1)
	nvgLineTo(-rOuterTimesRoot3By2,-rOuterBy2)
	nvgLineTo(-rOuterTimesRoot3By2,rOuterBy2)
	nvgLineTo(0,rOuterBy1)
	nvgPathWinding(NVG_HOLE)
	nvgMoveTo(0,rInnerBy1)
	nvgLineTo(rInnerTimesRoot3By2,rInnerBy2)
	nvgLineTo(rInnerTimesRoot3By2,-rInnerBy2)
	nvgLineTo(0,-rInnerBy1)
	nvgLineTo(-rInnerTimesRoot3By2,-rInnerBy2)
	nvgLineTo(-rInnerTimesRoot3By2,rInnerBy2)
	nvgLineTo(0,rInnerBy1)
	nvgRestore()
end

function thc_drawCameraLens(r,k)
	nvgSave()
	nvgScale(1/12,1/12)
	nvgBeginPath()
	local rBy1 = roundHalfDown(r*12)
	local rBy2 = roundHalfUp(r*6)
	local rTimesRoot3By2 = roundHalfUp(r*6*math.sqrt(3))
	nvgMoveTo(0,rBy1)
	nvgLineTo(rTimesRoot3By2,rBy2)
	nvgLineTo(rTimesRoot3By2,-rBy2)
	nvgLineTo(0,-rBy1)
	nvgLineTo(-rTimesRoot3By2,-rBy2)
	nvgLineTo(-rTimesRoot3By2,rBy2)
	nvgLineTo(0,rBy1)


	-- 
	nvgRestore()
end

local healthCrossColor = Color(255,255,255,255)

function thc_HealthIcon(r,color,k)
	local crossLength = roundHalfUp(r*12/2)*2
	local halfCrossLength = crossLength/2
	local crossWidth = roundHalfUp(r*12/6)*2
	local halfCrossWidth = crossWidth/2
	local borderWidth = r/12*2
	nvgSave()
	nvgScale(1/12,1/12)
	nvgBeginPath()
	thc_drawHexagonPath(roundHalfUp(12*(r-borderWidth)))
	nvgClosePath()
	nvgStrokeWidth(roundHalfUp(12*borderWidth))
	if k then
		nvgStrokeColor(color)
		nvgStroke()
		nvgScissor(-r*12,roundHalfDown(24*r*(0.5-k)),24*r,roundHalfDown(24*r*k))
		nvgFillColor(color)
		nvgFill()
		nvgResetScissor()
	else
		nvgStrokeColor(color)
		nvgStroke()
		nvgFillColor(color)
		nvgFill()
	end
	nvgBeginPath()
	nvgFillColor(THC_HEALTH_ICON_CROSS_COLOR(color.a*255/255))
	nvgRect(-halfCrossLength,-halfCrossWidth,crossLength,crossWidth)
	nvgRect(-halfCrossWidth,-halfCrossLength,crossWidth,crossLength)
	nvgClosePath()
	nvgFill()
	nvgRestore()
end

local function drawShieldPath(r)
	local rr = roundHalfUp(r)
	local x = roundHalfUp(r*2*0.9/2)
	local y = roundHalfUp(r*2*0.37/2)
	nvgMoveTo(0,rr)
	nvgLineTo(x,y)
	nvgLineTo(x,-rr)
	nvgLineTo(-x,-rr)
	nvgLineTo(-x,y)
	nvgLineTo(0,rr)
end

function thc_ArmorIcon(r,color)
	r = 12*r
	local rBy1 = roundHalfUp(r/2)*2
	local rBy2 = roundHalfUp(r/2)
	local rBy3 = roundHalfUp(r/6)*2
	local rBy6 = roundHalfUp(r/6)
	local borderWidth = roundHalfUp(r/12)*2
	nvgSave()
	nvgScale(1/12,1/12)
	nvgBeginPath()
	drawShieldPath(r-borderWidth/2)
	nvgClosePath()
	nvgStrokeColor(color)
	nvgStrokeWidth(borderWidth)
	nvgStroke()
	nvgTranslate(0,-roundHalfDown(r/23))
	nvgBeginPath()
	drawShieldPath(r*0.53)
	nvgStrokeWidth(r/2)
	nvgStrokeWidth(r/4)
	nvgFillColor(color)
	nvgFill()
	nvgStroke()
	nvgRestore()
end
