require "base/internal/ui/reflexcore"
require "base/internal/ui/thcHUD/thc_core"

local havePickups = false
local megaPlayerIndex = nil
local megaRemaining = 0
local lastHealth = {}
local lastArmor = {}

local orangeHealthColorFactory = THC_COLOR.ORANGE
local megaColorFactory = THC_COLOR.SKY_BLUE
local megaColor = megaColorFactory(255)
local notmegaColorFactory = THC_COLOR.GREY.NORMAL
local notmegaColor = notmegaColorFactory(255)

local healthMeterColorNormal = THC_HP_NORMAL_COLOR(255)
local healthMeterColorBuff = THC_HP_BUFF_COLOR(255)

local armorMeterColor = THC_HP_NORMAL_COLOR(255)
local armorIconColors = {THC_COLOR.GREEN(255),THC_COLOR.YELLOW(255),THC_COLOR.RED(255)}

local redArmorColorFactory = THC_COLOR.RED
local yellowArmorColorFactory = THC_COLOR.YELLOW
local greenArmorColorFactory = THC_COLOR.GREEN

local megaPickupMaxTime = 30
local healthPickupMaxTime = 25
local armorPickupMaxTime = 25

local pickupSettings = {}
pickupSettings[PICKUP_TYPE_HEALTH100] = {align=NVG_ALIGN_LEFT; colorFactory=THC_COLOR.SKY_BLUE; iconFactory=thc_HealthIcon; maxTime=30; isHealth = true;}
pickupSettings[PICKUP_TYPE_HEALTH50] = {align=NVG_ALIGN_LEFT; colorFactory=THC_COLOR.ORANGE; iconFactory=thc_HealthIcon; maxTime=25; isHealth = true;}
pickupSettings[PICKUP_TYPE_ARMOR150] = {align=NVG_ALIGN_RIGHT; colorFactory=THC_COLOR.RED; iconFactory=thc_ArmorIcon; maxTime=25; isArmor = true;}
pickupSettings[PICKUP_TYPE_ARMOR100] = {align=NVG_ALIGN_RIGHT; colorFactory=THC_COLOR.YELLOW; iconFactory=thc_ArmorIcon; maxTime=25; isArmor = true;}
pickupSettings[PICKUP_TYPE_ARMOR50] = {align=NVG_ALIGN_RIGHT; colorFactory=THC_COLOR.GREEN; iconFactory=thc_ArmorIcon; maxTime=25; isArmor = true;}
pickupSettings[PICKUP_TYPE_POWERUPCARNAGE] = nil

local function addHealthPickups(pickupType,colorF)
	for i=1,#pickupTimers do
		local pickup = pickupTimers[i]
		if pickup and pickup.type == pickupType then
			local remaining = nil
			if not pickup.isHeldByPlayer and not pickup.isHeldByPickup then
				local t = FormatTime(pickup.timeUntilRespawn)
				remaining = t.seconds + 60*t.minutes
			end
			if pickupType == PICKUP_TYPE_HEALTH100 then
				if pickup.isHeldByPlayer or pickup.isHeldByPickup then
					thc_drawTimer(NVG_ALIGN_LEFT,NVG_ALIGN_TOP,remaining,megaPickupMaxTime,thc_HealthIcon,notmegaColorFactory,megaRemaining/100)
				else
					thc_drawTimer(NVG_ALIGN_LEFT,NVG_ALIGN_TOP,remaining,megaPickupMaxTime,thc_HealthIcon,colorF)
				end
			else
				thc_drawTimer(NVG_ALIGN_LEFT,NVG_ALIGN_TOP,remaining,healthPickupMaxTime,thc_HealthIcon,colorF)
			end
			nvgTranslate(-(THC_TIMER_TRUE_WIDTH+THC_DEFAULT_SPACING),0)
		end
	end
end

local function addArmorPickups(pickupType,colorF)
	for i=1,#pickupTimers do
		local pickup = pickupTimers[i]
		if pickup and pickup.type == pickupType then
			local remaining = nil
			if not pickup.isHeldByPlayer and not pickup.isHeldByPickup then
				local t = FormatTime(pickup.timeUntilRespawn)
				remaining = t.seconds + 60*t.minutes
			end
			thc_drawTimer(NVG_ALIGN_RIGHT,NVG_ALIGN_TOP,remaining,armorPickupMaxTime,thc_ArmorIcon,colorF)
			nvgTranslate(THC_TIMER_TRUE_WIDTH+THC_DEFAULT_SPACING,0)
		end
	end
end

THC_PlayerHUD =
{
}

function THC_PlayerHUD:draw()
	if not thc_shouldTickGameHud() then
		megaRemaining = 0
		havePickups = false
		return
	end

	local shouldDrawTimersMega = false
	local shouldDrawTimers50HP = false
	local shouldDrawTimersRed = false
	local shouldDrawTimersYellow = false
	local shouldDrawTimersGreen = false

	if clientGameState == STATE_CONNECTED and world and world.gameModeIndex and gamemodes and gamemodes[world.gameModeIndex] then
		local requiredCvarTimers = (getLocalPlayer().state ~= PLAYER_STATE_INGAME and 1 or 2)
		if gamemodes[world.gameModeIndex].hasPickups then
			if not havePickups then
				havePickups = true
			end			
			shouldDrawTimersMega = (consoleGetVariable("ui_thc_pickuptimers_mega") >= requiredCvarTimers)
			shouldDrawTimers50HP = (consoleGetVariable("ui_thc_pickuptimers_50hp") >= requiredCvarTimers)
			shouldDrawTimersRed = (consoleGetVariable("ui_thc_pickuptimers_red") >= requiredCvarTimers)
			shouldDrawTimersYellow = (consoleGetVariable("ui_thc_pickuptimers_yellow") >= requiredCvarTimers)
			shouldDrawTimersGreen = (consoleGetVariable("ui_thc_pickuptimers_green") >= requiredCvarTimers)
		elseif havePickups then
			megaRemaining = 0
			megaPlayerIndex = nil
			havePickups = false
		end
		for p, player in pairs(players) do
			if player.connected and player.state == PLAYER_STATE_INGAME then 
				if havePickups then
					if player.hasMega then
						megaPlayerIndex = p
						if not (megaRemaining > 0) then megaRemaining = 100
						else
							if megaLastHealth > player.health then megaRemaining = megaRemaining - (megaLastHealth - player.health) end
							if megaLastArmor > player.armor then megaRemaining = megaRemaining - (megaLastArmor - player.armor) end
						end
						megaLastHealth = player.health
						megaLastArmor = player.armor
					elseif megaPlayerIndex == p then
						megaRemaining = 0
						megaPlayerIndex = nil
					end
				end
			end
		end
	elseif havePickups then
		megaRemaining = 0
		megaPlayerIndex = nil
		havePickups = false
	end
	if not thc_shouldDrawGameHud() then return end
	nvgSave()
	local offset = 0
	if havePickups and not thc_shouldDrawPlayerHud() then
		local healthCount = 0
		local armorCount = 0
		for p,pickup in pairs(pickupTimers) do
			local settings = pickupSettings[pickup.type]
			if settings then
				if settings.isHealth then
					healthCount = healthCount + 1
				elseif settings.isArmor then
					armorCount = armorCount + 1
				end
			end
		end
		offset = roundHalfUp((healthCount - armorCount)*(THC_TIMER_TRUE_WIDTH+1)/2)
	end
	nvgTranslate(offset,-47)
	nvgSave()
	if thc_shouldDrawPlayerHud() then
		thc_drawMeter(NVG_ALIGN_LEFT,NVG_ALIGN_TOP,getPlayer().health,100,healthMeterColorNormal,healthMeterColorBuff,math.max(getPlayer().health,0),THC_METER)
		nvgSave()
		nvgTranslate(-THC_METER.CALC_ICON_MARGIN,-THC_METER.MIDPOINT_Y)
		thc_HealthIcon(THC_ICON_SMALL_RADIUS,getPlayer().hasMega and megaColor or notmegaColor,((megaPlayerIndex == playerIndexCameraAttachedTo) and megaRemaining or 0)/100)
		nvgRestore()
		nvgTranslate(-(THC_METER.TRUE_WIDTH+THC_METER.TRUE_X+THC_DEFAULT_SPACING), 0)
	else
		nvgTranslate(-math.ceil(THC_DEFAULT_SPACING/2),0)
	end
	if havePickups then
		if shouldDrawTimersMega then addHealthPickups(PICKUP_TYPE_HEALTH100,megaColorFactory) end
		if shouldDrawTimers50HP then addHealthPickups(PICKUP_TYPE_HEALTH50,orangeHealthColorFactory) end
	end
	nvgRestore()

	nvgSave()
	if thc_shouldDrawPlayerHud() then
		thc_drawMeter(NVG_ALIGN_RIGHT,NVG_ALIGN_TOP,getPlayer().armor,200,armorMeterColor,nil,math.max(getPlayer().armor,0),THC_METER)
		nvgSave()
		nvgTranslate(THC_METER.CALC_ICON_MARGIN,-THC_METER.MIDPOINT_Y)
		thc_ArmorIcon(THC_ICON_SMALL_RADIUS,armorIconColors[getPlayer().armorProtection+1])
		nvgRestore()
		nvgTranslate(THC_METER.TRUE_WIDTH+THC_METER.TRUE_X+THC_DEFAULT_SPACING, 0)
	else
		nvgTranslate(math.floor(THC_DEFAULT_SPACING/2),0)
	end
	if havePickups then
		if shouldDrawTimersRed then addArmorPickups(PICKUP_TYPE_ARMOR150,redArmorColorFactory) end
		if shouldDrawTimersYellow then addArmorPickups(PICKUP_TYPE_ARMOR100,yellowArmorColorFactory) end
		if shouldDrawTimersGreen then addArmorPickups(PICKUP_TYPE_ARMOR50,greenArmorColorFactory) end
	end
	nvgRestore()
	if thc_shouldDrawPlayerHud() then
		if consoleGetVariable("ui_thc_speedmeter") >= 1 then
			local speed = getPlayer().speed
			local maxSpeed = consoleGetVariable("ui_thc_speedmeter_max")
			if maxSpeed <= 0 then
				local adjustedSpeed = 1-((0.8)^((speed/320)^2))
				local meterValue = (adjustedSpeed^2) * ((2 - adjustedSpeed)^2)
				nvgTranslate(-roundHalfUp(THC_SPEED.FULL_WIDTH/2),-THC_METER.FULL_HEIGHT)
				thc_drawMeter(NVG_ALIGN_RIGHT,NVG_ALIGN_TOP,meterValue,1,armorMeterColor,nil,math.ceil(speed).."ups",THC_SPEED)
			else
				nvgTranslate(-roundHalfUp(THC_SPEED.FULL_WIDTH/2),-THC_METER.FULL_HEIGHT)
				thc_drawMeter(NVG_ALIGN_RIGHT,NVG_ALIGN_TOP,speed,maxSpeed,armorMeterColor,nil,math.ceil(speed).."ups",THC_SPEED)
			end
		end
		nvgRestore()
		nvgSave()
		nvgTranslate(THC_WEAPONRACK_LEFT,-THC_WEAPONSLOT_TRUE_HEIGHT)
		for i=1,8 do
			thc_drawWeaponSlot(i,getPlayer().weapons[i].ammo,getPlayer().weapons[i].color)
			nvgTranslate(THC_WEAPONSLOT_TRUE_WIDTH+THC_DEFAULT_SPACING,0)
		end
	end
	nvgRestore()
end

registerWidget("THC_PlayerHUD")
