require "base/internal/ui/reflexcore"
require "base/internal/ui/thcHUD/thc_core"

THC_Scores =
{
}
registerWidget("THC_Scores")

local meterColorExcess = THC_COLOR.FOREST_GREEN.NORMAL(255)
local meterColorNormal = THC_COLOR.FOREST_GREEN.LIGHTER(255)
local meterColorBuff = THC_COLOR.FOREST_GREEN.LIGHTEST(255)

local playerRanking = nil
local playerLastRanks = {}

local scoresVisibleTimer = 0

local pingTransitionOffset = 0
local pingTransition = 0.5
local pingDelay = 1

local function drawPlayerScore(player, yOffset, relativeScores)
	if not playerRanking then return end
	local playerIndex = player.index
	if not playerIndex then return end
	nvgSave()
	nvgTranslate(0,yOffset)

	-- background
	nvgBeginPath()
	nvgRect(THC_SCORE.X+pingTransitionOffset,THC_SCORE.Y,THC_SCORE.CALC_WIDTH-pingTransitionOffset,THC_SCORE.CALC_HEIGHT)
	nvgFillColor(THC_SCORE.BACKGROUND_COLOR)
	nvgFill()
	nvgStrokeColor(THC_SCORE.BORDER_COLOR)
	nvgStrokeWidth(THC_SCORE.BORDER)
	nvgStroke()

	nvgTranslate(THC_SCORE.BORDER,THC_SCORE.BORDER)

	-- health/armor bars
	local health = math.min(math.max(player.health,0),200)
	local maxArmor = math.min(math.floor(health*(player.armorProtection+1)),200)
	local armor = player.armor
	local trueArmor = math.min(maxArmor,armor)
	local falseArmor = armor - trueArmor
	nvgSave()
	nvgTranslate(THC_SCORE.METER.OFFSET_X,THC_SCORE.METER.OFFSET_Y)
	thc_drawMeter(NVG_ALIGN_LEFT,NVG_ALIGN_TOP,health,100,meterColorNormal,meterColorBuff,"",THC_SCORE.METER)
	thc_drawDoubleMeter(NVG_ALIGN_RIGHT,NVG_ALIGN_TOP,armor,trueArmor,200,meterColorExcess,meterColorNormal,"",THC_SCORE.METER)
	nvgRestore()

	local specScore = players[playerIndexCameraAttachedTo].score

	nvgSave()
	nvgTranslate(pingTransitionOffset,0)
	-- spec icon
	nvgBeginPath()
	nvgFillColor(THC_SCORE.SPEC_ICON.INACTIVE_BACKGROUND_COLOR)
	nvgRect(THC_SCORE.SPEC_ICON.X,THC_SCORE.SPEC_ICON.Y,THC_SCORE.SPEC_ICON.CALC_WIDTH-pingTransitionOffset,THC_SCORE.SPEC_ICON.CALC_HEIGHT)
	nvgFill()
	if(THC_SCORE.SPEC_ICON.BORDER > 0) then nvgStrokeColor(THC_SCORE.SPEC_ICON.BORDER_COLOR) nvgStrokeWidth(THC_SCORE.SPEC_ICON.BORDER) nvgStroke() end

	if playerIndex == playerIndexCameraAttachedTo then
		nvgBeginPath()
		nvgFillColor(THC_SCORE.SPEC_ICON.ACTIVE_BACKGROUND_COLOR)
		nvgRect(THC_SCORE.SPEC_ICON.X,THC_SCORE.SPEC_ICON.Y,THC_SCORE.SPEC_ICON.CALC_WIDTH,THC_SCORE.SPEC_ICON.CALC_HEIGHT)
		nvgFill()
		if(THC_SCORE.SPEC_ICON.BORDER > 0) then nvgStrokeColor(THC_SCORE.SPEC_ICON.BORDER_COLOR) nvgStrokeWidth(THC_SCORE.SPEC_ICON.BORDER) nvgStroke() end
		nvgSave()
		nvgStrokeColor(THC_SCORE.SPEC_ICON.ACTIVE_COLOR)
		nvgFillColor(THC_SCORE.SPEC_ICON.ACTIVE_COLOR)
		nvgTranslate(THC_SCORE.SPEC_ICON.MIDPOINT_X,THC_SCORE.SPEC_ICON.MIDPOINT_Y)
		nvgStrokeWidth(roundHalfUp(THC_SCORE.SPEC_ICON.RADIUS/4))
		nvgBeginPath()
		thc_drawHexagonPath(THC_SCORE.SPEC_ICON.RADIUS)
		nvgStroke()
		nvgBeginPath()
		if world.gameState ~= GAME_STATE_WARMUP or player.ready then
			nvgSave()
			nvgRotate(math.pi/2)
			nvgScale(0.3,0.3)
			thc_drawHexagonPath(THC_SCORE.SPEC_ICON.RADIUS)
			nvgRestore()
			nvgStroke()
			nvgFill()
		end
		nvgRestore()
	else
		nvgBeginPath()
		nvgFillColor(THC_SCORE.SPEC_ICON.INACTIVE_BACKGROUND_COLOR)
		nvgRect(THC_SCORE.SPEC_ICON.X,THC_SCORE.SPEC_ICON.Y,THC_SCORE.SPEC_ICON.CALC_WIDTH,THC_SCORE.SPEC_ICON.CALC_HEIGHT)
		nvgFill()
		if(THC_SCORE.SPEC_ICON.BORDER > 0) then nvgStrokeColor(THC_SCORE.SPEC_ICON.BORDER_COLOR) nvgStrokeWidth(THC_SCORE.SPEC_ICON.BORDER) nvgStroke() end
		nvgSave()
		nvgStrokeColor(THC_SCORE.SPEC_ICON.INACTIVE_COLOR)
		nvgFillColor(THC_SCORE.SPEC_ICON.INACTIVE_COLOR)
		nvgTranslate(THC_SCORE.SPEC_ICON.MIDPOINT_X,THC_SCORE.SPEC_ICON.MIDPOINT_Y)
		nvgStrokeWidth(roundHalfUp(THC_SCORE.SPEC_ICON.RADIUS/4))
		nvgBeginPath()
		thc_drawHexagonPath(THC_SCORE.SPEC_ICON.RADIUS)
		nvgStroke()
		nvgBeginPath()
		if world.gameState ~= GAME_STATE_WARMUP or player.ready then
			nvgSave()
			nvgRotate(math.pi/2)
			nvgScale(0.3,0.3)
			thc_drawHexagonPath(THC_SCORE.SPEC_ICON.RADIUS)
			nvgRestore()
			nvgStroke()
			nvgFill()
		end
		nvgRestore()
	end
	if pingTransitionOffset ~= 0 then
		nvgScissor(THC_SCORE.SPEC_ICON.X,THC_SCORE.SPEC_ICON.Y,THC_SCORE.SPEC_ICON.WIDTH+THC_SCORE.SPEC_ICON.BORDER/2-pingTransitionOffset,THC_SCORE.SPEC_ICON.CALC_HEIGHT)
		nvgBeginPath()
		nvgFontFace(THC_SCORE.NETWORK.FONT_FACE)
		nvgFontSize(THC_SCORE.NETWORK.FONT_SIZE)
		nvgFontBlur(0)
		if player.latency <= 80 then
			nvgFillColor(THC_SCORE.NETWORK.FONT_COLOR_GOOD)
		else
			nvgFillColor(THC_SCORE.NETWORK.FONT_COLOR_BAD)
		end
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_BOTTOM)
		nvgText(THC_SCORE.NETWORK.X,THC_SCORE.NETWORK.PING_Y,player.latency.."ms")
		if player.packetLoss == 0 then
			nvgFillColor(THC_SCORE.NETWORK.FONT_COLOR_GOOD)
		else
			nvgFillColor(THC_SCORE.NETWORK.FONT_COLOR_BAD)
		end
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_TOP)
		nvgText(THC_SCORE.NETWORK.X,THC_SCORE.NETWORK.PACKETLOSS_Y,player.packetLoss.." PL")
		nvgResetScissor()
	end
	nvgRestore()
	
	local score = player.score
	nvgBeginPath()
	nvgRect(THC_SCORE.VALUE.X,THC_SCORE.VALUE.Y,THC_SCORE.VALUE.CALC_WIDTH,THC_SCORE.VALUE.CALC_HEIGHT)
	nvgFontBlur(0)
	nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE)

	if world.gameState == GAME_STATE_WARMUP then
		nvgFillColor(THC_SCORE.VALUE.BACKGROUND_COLOR)
		nvgFill()
		if(THC_SCORE.VALUE.BORDER > 0) then nvgStrokeColor(THC_SCORE.VALUE.BORDER_COLOR) nvgStrokeWidth(THC_SCORE.VALUE.BORDER) nvgStroke() end
		nvgFontSize(THC_SCORE.VALUE.FONT_SIZE_WARMUP)
		nvgFontFace(THC_SCORE.VALUE.FONT_FACE)
		if player.ready then
			nvgFillColor(THC_SCORE.VALUE.FONT_COLOR_READY)
		else
			nvgFillColor(THC_SCORE.VALUE.FONT_COLOR_NOT_READY)
		end
		score = "READY"
	else
		nvgFillColor(THC_SCORE.VALUE.BACKGROUND_COLOR)
		nvgFill()
		if(THC_SCORE.VALUE.BORDER > 0) then nvgStrokeColor(THC_SCORE.VALUE.BORDER_COLOR) nvgStrokeWidth(THC_SCORE.VALUE.BORDER) nvgStroke() end
		nvgFillColor(THC_SCORE.VALUE.FONT_COLOR)
		nvgFontSize(THC_SCORE.VALUE.FONT_SIZE)
		nvgFontFace(THC_SCORE.VALUE.FONT_FACE)
	end
	nvgBeginPath()
	if relativeScores and playerRanking[1].index == playerIndex then
		nvgText(THC_SCORE.VALUE.MIDPOINT_X,THC_SCORE.VALUE.SCORE_Y_LEAD,score)
	elseif relativeScores and playerRanking[2].index == playerIndex then
		nvgText(THC_SCORE.VALUE.MIDPOINT_X,THC_SCORE.VALUE.SCORE_Y_TAIL,score)
	else
		nvgText(THC_SCORE.VALUE.MIDPOINT_X,THC_SCORE.VALUE.MIDPOINT_Y,score)
	end
	
	-- mega icon
	nvgSave()
	nvgTranslate(THC_SCORE.HEALTH_ICON.X,THC_SCORE.HEALTH_ICON.Y)
	if player.hasMega then
		thc_HealthIcon(THC_SCORE.ICON_RADIUS,THC_SCORE.HEALTH_ICON.ACTIVE_COLOR(255))
	else
		thc_HealthIcon(THC_SCORE.ICON_RADIUS,THC_SCORE.HEALTH_ICON.INACTIVE_COLOR(32))
	end
	nvgRestore()

	-- armor icon
	nvgSave()
	nvgTranslate(THC_SCORE.ARMOR_ICON.X,THC_SCORE.ARMOR_ICON.Y)
	thc_ArmorIcon(THC_SCORE.ICON_RADIUS,THC_SCORE.ARMOR_ICON.COLOR[player.armorProtection+1] or THC_COLOR.GREY.NORMAL(255))
	nvgRestore()

	-- name
	nvgBeginPath()
	nvgFillColor(THC_SCORE.NAME.FONT_COLOR)
	nvgFontFace(THC_SCORE.NAME.FONT_FACE)
	nvgTextAlign(NVG_ALIGN_RIGHT, NVG_ALIGN_MIDDLE)
	nvgFontSize(THC_SCORE.NAME.FONT_SIZE)
	local requiredWidth = nvgTextWidth(player.name)
	if requiredWidth > THC_SCORE.NAME.WIDTH then nvgFontSize(math.floor(THC_SCORE.NAME.FONT_SIZE*THC_SCORE.NAME.WIDTH/requiredWidth)) end
	nvgFontBlur(0)
	nvgText(THC_SCORE.NAME.X,THC_SCORE.NAME.Y,player.name)

	nvgRestore()
end

local function drawSpectator(player, yOffset)
	local playerIndex = player.index
	if not playerIndex then return end
	local isQueued = (player.state == PLAYER_STATE_QUEUED)
	nvgSave()
	nvgTranslate(THC_SPEC.X_OFFSET,yOffset)

	-- background
	nvgBeginPath()
	nvgRect(THC_SPEC.X + (isQueued and 0 or THC_SPEC.VALUE.CALC_WIDTH),THC_SPEC.Y,THC_SPEC.CALC_WIDTH - (isQueued and 0 or THC_SPEC.VALUE.TRUE_WIDTH),THC_SPEC.CALC_HEIGHT)
	nvgFillColor(isQueued and THC_SPEC.BACKGROUND_COLOR or THC_SPEC.BACKGROUND_COLOR_NOTQUEUED)
	nvgFill()
	nvgStrokeColor(isQueued and THC_SPEC.BORDER_COLOR or THC_SPEC.BORDER_COLOR_NOTQUEUED)
	nvgStrokeWidth(THC_SPEC.BORDER)
	nvgStroke()

	if isQueued then
		-- score background
		nvgBeginPath()
		nvgRect(THC_SPEC.VALUE.X,THC_SPEC.VALUE.Y,THC_SPEC.VALUE.CALC_WIDTH,THC_SPEC.VALUE.CALC_HEIGHT)
		nvgFillColor(THC_SPEC.VALUE.BACKGROUND_COLOR)
		nvgFill()

		-- score value
		nvgBeginPath()
		nvgFillColor(THC_SPEC.VALUE.FONT_COLOR)
		nvgFontSize(THC_SPEC.VALUE.FONT_SIZE)
		nvgFontFace(THC_SPEC.VALUE.FONT_FACE)
		nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE)
		nvgFontBlur(0)
		nvgText(THC_SPEC.VALUE.MIDPOINT_X,THC_SPEC.VALUE.MIDPOINT_Y,player.queuePosition)
	end
	-- name
	nvgBeginPath()
	nvgFillColor(THC_SPEC.NAME.FONT_COLOR)
	nvgFontFace(THC_SPEC.NAME.FONT_FACE)
	nvgTextAlign(NVG_ALIGN_LEFT, NVG_ALIGN_MIDDLE)
	nvgFontSize(THC_SPEC.NAME.FONT_SIZE)
	local requiredWidth = nvgTextWidth(player.name)
	if requiredWidth > THC_SPEC.NAME.WIDTH then nvgFontSize(math.floor(THC_SPEC.NAME.FONT_SIZE*THC_SPEC.NAME.WIDTH/requiredWidth)) end
	nvgFontBlur(0)
	nvgText(THC_SPEC.NAME.X,THC_SPEC.NAME.Y,player.name)

	nvgRestore()
end

local function drawEndgamePlayer(player, yOffset)
	if not playerRanking then return end
	local playerIndex = player.index
	if not playerIndex then return end
	local isWinner
	if playerRanking[1].index == playerIndex and (not playerRanking[2] or playerRanking[1].score > playerRanking[2].score) then isWinner = true
	else isWinner = false end

	nvgSave()
	nvgTranslate(0,yOffset)

	-- background
	nvgBeginPath()
	nvgRect(THC_GAMEOVER.X+pingTransitionOffset,THC_GAMEOVER.Y,THC_GAMEOVER.CALC_WIDTH-pingTransitionOffset,THC_GAMEOVER.CALC_HEIGHT)
	if isWinner then nvgFillColor(THC_GAMEOVER.BACKGROUND_COLOR_WIN)
	else nvgFillColor(THC_GAMEOVER.BACKGROUND_COLOR) end
	nvgFill()
	nvgStrokeColor(THC_GAMEOVER.BORDER_COLOR)
	nvgStrokeWidth(THC_GAMEOVER.BORDER)
	nvgStroke()

	nvgTranslate(THC_GAMEOVER.BORDER,THC_GAMEOVER.BORDER)
	
	local score = player.score
	nvgBeginPath()
	nvgRect(THC_GAMEOVER.VALUE.X,THC_GAMEOVER.VALUE.Y,THC_GAMEOVER.VALUE.CALC_WIDTH,THC_GAMEOVER.VALUE.CALC_HEIGHT)
	nvgFontBlur(0)
	nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE)
	if isWinner then nvgFillColor(THC_GAMEOVER.VALUE.BACKGROUND_COLOR_WIN)nvgFill()nvgFillColor(THC_GAMEOVER.VALUE.FONT_COLOR_WIN)
	else nvgFillColor(THC_GAMEOVER.VALUE.BACKGROUND_COLOR)nvgFill()nvgFillColor(THC_GAMEOVER.VALUE.FONT_COLOR) end
	
	if(THC_GAMEOVER.VALUE.BORDER > 0) then nvgStrokeColor(THC_GAMEOVER.VALUE.BORDER_COLOR) nvgStrokeWidth(THC_GAMEOVER.VALUE.BORDER) nvgStroke() end
	
	nvgFontSize(THC_GAMEOVER.VALUE.FONT_SIZE)
	nvgFontFace(THC_GAMEOVER.VALUE.FONT_FACE)

	nvgBeginPath()
	if relativeScores and playerRanking[1].index == playerIndex then
		nvgText(THC_GAMEOVER.VALUE.MIDPOINT_X,THC_GAMEOVER.VALUE.SCORE_Y_LEAD,score)
	elseif relativeScores and playerRanking[2].index == playerIndex then
		nvgText(THC_GAMEOVER.VALUE.MIDPOINT_X,THC_GAMEOVER.VALUE.SCORE_Y_TAIL,score)
	else
		nvgText(THC_GAMEOVER.VALUE.MIDPOINT_X,THC_GAMEOVER.VALUE.MIDPOINT_Y,score)
	end

	-- name
	nvgBeginPath()
	if isWinner then nvgFillColor(THC_GAMEOVER.NAME.FONT_COLOR_WIN) else nvgFillColor(THC_GAMEOVER.NAME.FONT_COLOR) end
	nvgFontFace(THC_GAMEOVER.NAME.FONT_FACE)
	nvgTextAlign(NVG_ALIGN_CENTER, NVG_ALIGN_MIDDLE)
	nvgFontSize(THC_GAMEOVER.NAME.FONT_SIZE)
	local requiredWidth = nvgTextWidth(player.name)
	if requiredWidth > THC_GAMEOVER.NAME.WIDTH then nvgFontSize(math.floor(THC_GAMEOVER.NAME.FONT_SIZE*THC_GAMEOVER.NAME.WIDTH/requiredWidth)) end
	nvgFontBlur(0)
	nvgText(THC_GAMEOVER.NAME.X,THC_GAMEOVER.NAME.Y,player.name)

	nvgRestore()
end

local function sortByScore(a,b)
	if a.score ~= b.score then return a.score > b.score else return a.lastRank < b.lastRank end
end

local function sortByQueue(a,b)
	return a.queuePosition > b.queuePosition
end

local spectators = nil
local queue = nil

function THC_Scores:draw()
	if not thc_shouldTickGameHud() then return end
	if world.gameState == GAME_STATE_GAMEOVER then return end
	local shouldDraw = (thc_shouldDrawSpecHud() or showScores or (thc_shouldDrawGameHud() and consoleGetVariable("ui_thc_scoreboard_force_ingame") >= 1))
	if showScores then
		pingTransition = consoleGetVariable("ui_thc_scoreboard_ping_transition")
		pingDelay = consoleGetVariable("ui_thc_scoreboard_ping_delay")
		if scoresVisibleTimer < pingDelay + pingTransition then
			scoresVisibleTimer = scoresVisibleTimer + deltaTimeRaw
		end
	elseif scoresVisibleTimer > 0 then
		scoresVisibleTimer = scoresVisibleTimer - deltaTimeRaw
	end
	pingTransitionOffset = -math.floor(THC_SCORE.SPEC_ICON.WIDTH*math.max(0,math.min(1,(scoresVisibleTimer - pingDelay)/pingTransition)))
	nvgSave()
	nvgTranslate(-THC_SCORE.FULL_WIDTH,0)
	local numActivePlayers = 0
	playerRanking = {}
	spectators = {}
	queue = {}

	for p,player in pairs(players) do
		if player.connected and player.state == PLAYER_STATE_INGAME then
			numActivePlayers = numActivePlayers+1
			playerRanking[numActivePlayers] = player
			player.index = p
			player.lastRank = playerLastRanks[p] or #playerLastRanks + p
		elseif player.connected and showScores then
			if player.state == PLAYER_STATE_QUEUED then
				queue[#queue+1] = player
			else
				spectators[#spectators+1] = player
			end
			player.index = p
		end
	end
	table.sort(playerRanking,sortByScore)

	playerLastRanks = {}
	for r=#playerRanking,1,-1 do
		if shouldDraw then drawPlayerScore(playerRanking[r],(r-1)*(THC_SCORE.TRUE_HEIGHT+THC_DEFAULT_SPACING),relativeScores) end
		playerLastRanks[playerRanking[r].index] = r
	end

	nvgRestore()

	if not shouldDraw then return end

	relativeScores = (world.gameModeIndex == 2 and (world.gameState == GAME_STATE_ACTIVE or world.gameState == GAME_STATE_GAMEOVER) and #playerRanking == 2)
	if relativeScores then
		local difference
		nvgBeginPath()
		nvgRect(-THC_SCORE.BORDER/2,THC_SCORE.DIFFERENCE.Y,-THC_SCORE.VALUE.CALC_WIDTH,THC_SCORE.DIFFERENCE.HEIGHT)
		if playerRanking[1].score == playerRanking[2].score then
			nvgFillColor(THC_SCORE.DIFFERENCE.COLOR_EQUAL)
			difference = "TIE"
		elseif playerIndexCameraAttachedTo == playerRanking[1].index then
			nvgFillColor(THC_SCORE.DIFFERENCE.COLOR_AHEAD)
			difference = string.format("%+i",playerRanking[1].score-playerRanking[2].score)
		else
			nvgFillColor(THC_SCORE.DIFFERENCE.COLOR_BEHIND)
			difference = string.format("%+i",playerRanking[2].score-playerRanking[1].score)
		end
		nvgFill()
		nvgBeginPath()
		nvgMoveTo(-THC_SCORE.BORDER/2,THC_SCORE.DIFFERENCE.Y)
		nvgLineTo(-THC_SCORE.BORDER/2,THC_SCORE.DIFFERENCE.Y+THC_SCORE.DIFFERENCE.HEIGHT)
		nvgStrokeWidth(THC_SCORE.BORDER)
		nvgStrokeColor(THC_SCORE.BORDER_COLOR)
		nvgStroke()
		nvgBeginPath()
		nvgMoveTo(THC_SCORE.DIFFERENCE.LEFT_BORDER_X,THC_SCORE.DIFFERENCE.Y)
		nvgLineTo(THC_SCORE.DIFFERENCE.LEFT_BORDER_X,THC_SCORE.DIFFERENCE.Y+THC_SCORE.DIFFERENCE.HEIGHT)
		nvgStrokeWidth(THC_SCORE.VALUE.BORDER)
		nvgStrokeColor(THC_SCORE.VALUE.BORDER_COLOR)
		nvgStroke()
		nvgBeginPath()
		nvgFillColor(THC_SCORE.DIFFERENCE.FONT_COLOR)
		nvgFontSize(THC_SCORE.DIFFERENCE.FONT_SIZE)
		nvgFontFace(THC_SCORE.DIFFERENCE.FONT_FACE)
		nvgFontBlur(0)
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
		if playerRanking[1].score == playerRanking[2].score then
			nvgText(THC_SCORE.DIFFERENCE.MIDPOINT_X,THC_SCORE.TRUE_HEIGHT+THC_DEFAULT_SPACING,difference)
		else
			nvgText(THC_SCORE.DIFFERENCE.VALUE_X,THC_SCORE.TRUE_HEIGHT+THC_DEFAULT_SPACING,difference)
		end
	end
end

THC_FinalScores = {}
registerWidget("THC_FinalScores")

local crosshairHidden = false

function THC_FinalScores:draw()
	if not thc_shouldDrawGameHud(true) or world.gameState ~= GAME_STATE_GAMEOVER then if crosshairHidden then consolePerformCommand("ui_show_widget crosshairs") crosshairHidden = false end return end
	if not crosshairHidden then consolePerformCommand("ui_hide_widget crosshairs") crosshairHidden = true end
	

	pingTransitionOffset = 0

	nvgSave()
	local numActivePlayers = 0
	playerRanking = {}
	spectators = {}
	queue = {}

	for p,player in pairs(players) do
		if player.connected and player.state == PLAYER_STATE_INGAME then
			numActivePlayers = numActivePlayers+1
			playerRanking[numActivePlayers] = player
			player.index = p
			player.lastRank = playerLastRanks[p] or #playerLastRanks + p
		elseif player.connected and showScores then
			if player.state == PLAYER_STATE_QUEUED then
				queue[#queue+1] = player
			else
				spectators[#spectators+1] = player
			end
			player.index = p
		end
	end
	table.sort(playerRanking,sortByScore)

	nvgTranslate(-roundHalfUp(THC_GAMEOVER.FULL_WIDTH/2),-roundHalfUp((THC_GAMEOVER.TRUE_HEIGHT+THC_DEFAULT_SPACING)*(numActivePlayers/2)))
	playerLastRanks = {}
	for r=#playerRanking,1,-1 do
		drawEndgamePlayer(playerRanking[r],(r-1)*(THC_GAMEOVER.TRUE_HEIGHT+THC_DEFAULT_SPACING),relativeScores)
		playerLastRanks[playerRanking[r].index] = r
	end
	
	
	nvgTranslate(THC_GAMEOVER.FULL_WIDTH,0)
	relativeScores = (world.gameModeIndex == 2 and (world.gameState == GAME_STATE_ACTIVE or world.gameState == GAME_STATE_GAMEOVER) and #playerRanking == 2)
	if relativeScores then
		local difference
		nvgBeginPath()
		nvgRect(-THC_GAMEOVER.BORDER/2,THC_GAMEOVER.DIFFERENCE.Y,-THC_GAMEOVER.VALUE.CALC_WIDTH,THC_GAMEOVER.DIFFERENCE.HEIGHT)
		if playerRanking[1].score == playerRanking[2].score then
			nvgFillColor(THC_GAMEOVER.DIFFERENCE.COLOR_EQUAL)
			difference = "TIE"
		else
			nvgFillColor(THC_GAMEOVER.DIFFERENCE.COLOR_WINNER)
			difference = string.format("%+i",playerRanking[1].score-playerRanking[2].score)
		end
		nvgFill()
		nvgBeginPath()
		nvgMoveTo(-THC_GAMEOVER.BORDER/2,THC_GAMEOVER.DIFFERENCE.Y)
		nvgLineTo(-THC_GAMEOVER.BORDER/2,THC_GAMEOVER.DIFFERENCE.Y+THC_GAMEOVER.DIFFERENCE.HEIGHT)
		nvgStrokeWidth(THC_GAMEOVER.BORDER)
		nvgStrokeColor(THC_GAMEOVER.BORDER_COLOR)
		nvgStroke()
		nvgBeginPath()
		nvgMoveTo(THC_GAMEOVER.DIFFERENCE.LEFT_BORDER_X,THC_GAMEOVER.DIFFERENCE.Y)
		nvgLineTo(THC_GAMEOVER.DIFFERENCE.LEFT_BORDER_X,THC_GAMEOVER.DIFFERENCE.Y+THC_GAMEOVER.DIFFERENCE.HEIGHT)
		nvgStrokeWidth(THC_GAMEOVER.VALUE.BORDER)
		nvgStrokeColor(THC_GAMEOVER.VALUE.BORDER_COLOR)
		nvgStroke()
		nvgBeginPath()
		nvgFillColor(THC_GAMEOVER.DIFFERENCE.FONT_COLOR)
		nvgFontSize(THC_GAMEOVER.DIFFERENCE.FONT_SIZE)
		nvgFontFace(THC_GAMEOVER.DIFFERENCE.FONT_FACE)
		nvgFontBlur(0)
		nvgTextAlign(NVG_ALIGN_CENTER,NVG_ALIGN_MIDDLE)
		if playerRanking[1].score == playerRanking[2].score then
			nvgText(THC_GAMEOVER.DIFFERENCE.MIDPOINT_X,THC_GAMEOVER.TRUE_HEIGHT+THC_DEFAULT_SPACING,difference)
		else
			nvgText(THC_GAMEOVER.DIFFERENCE.VALUE_X,THC_GAMEOVER.TRUE_HEIGHT+THC_DEFAULT_SPACING,difference)
		end
	end
nvgRestore()
end

THC_Spectators =
{
}
registerWidget("THC_Spectators")

function THC_Spectators:draw()
	if not thc_shouldDrawGameHud() then if queue then queue = nil end if spectators then spectators = nil end return end
	if not queue and not spectators then return end
	nvgSave()
	if #queue > 0 then
		table.sort(queue,sortByQueue)
		nvgFontFace(THC_SPEC.LABEL.FONT_FACE)
		nvgFontSize(THC_SPEC.LABEL.FONT_SIZE)
		nvgTextAlign(NVG_ALIGN_LEFT,NVG_ALIGN_MIDDLE)
		nvgFontBlur(4)
		nvgFillColor(THC_SPEC.LABEL.FONT_COLOR_SHADOW)
		nvgText(THC_SPEC.VALUE.TRUE_WIDTH,THC_SPEC.MIDPOINT_Y,"QUEUED")
		nvgFontBlur(0)
		nvgFillColor(THC_SPEC.LABEL.FONT_COLOR_QUEUED)
		nvgText(THC_SPEC.VALUE.TRUE_WIDTH,THC_SPEC.MIDPOINT_Y,"QUEUED")
		nvgTranslate(0,THC_SPEC.TRUE_HEIGHT + THC_DEFAULT_SPACING)
		for p=#queue,1,-1 do
			drawSpectator(queue[p], 0)
			nvgTranslate(0,THC_SPEC.TRUE_HEIGHT + THC_DEFAULT_SPACING)
		end
		nvgTranslate(0,THC_SPEC.TRUE_HEIGHT + THC_DEFAULT_SPACING)
	end
	if #spectators > 0 then
		nvgFontFace(THC_SPEC.LABEL.FONT_FACE)
		nvgFontSize(THC_SPEC.LABEL.FONT_SIZE)
		nvgTextAlign(NVG_ALIGN_LEFT,NVG_ALIGN_MIDDLE)
		nvgFontBlur(4)
		nvgFillColor(THC_SPEC.LABEL.FONT_COLOR_SHADOW)
		nvgText(THC_SPEC.VALUE.TRUE_WIDTH,THC_SPEC.MIDPOINT_Y,"SPECTATORS")
		nvgFontBlur(0)
		nvgFillColor(THC_SPEC.LABEL.FONT_COLOR_SPECTATOR)
		nvgText(THC_SPEC.VALUE.TRUE_WIDTH,THC_SPEC.MIDPOINT_Y,"SPECTATORS")
		nvgTranslate(0,THC_SPEC.TRUE_HEIGHT + THC_DEFAULT_SPACING)
		for _,player in pairs(spectators) do
			drawSpectator(player, 0)
			nvgTranslate(0,THC_SPEC.TRUE_HEIGHT + THC_DEFAULT_SPACING)
		end
	end
	nvgRestore()
	playerRanking = nil
end
